/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.mvc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.function.Function;
import javax.inject.Inject;
import javax.mvc.MvcContext;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

public class ParamConverterProviderImpl
implements ParamConverterProvider {
    @Inject
    private MvcContext mvcContext;

    public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (rawType == null) {
            return null;
        }
        if (rawType.equals(Integer.class) || rawType.equals(Integer.TYPE) || rawType.equals(Long.class) || rawType.equals(Long.TYPE) || rawType.equals(Double.class) || rawType.equals(Double.TYPE) || rawType.equals(Float.class) || rawType.equals(Float.TYPE) || rawType.equals(Boolean.class) || rawType.equals(Boolean.TYPE)) {
            return new ParamConverter<T>(){

                public T fromString(String value) {
                    if (value == null) {
                        throw new IllegalArgumentException("Unable to convert a null parameter value");
                    }
                    if (rawType.equals(Integer.class) || rawType.equals(Integer.TYPE)) {
                        Function<Number, Integer> numberIntegerFunction = new Function<Number, Integer>(){

                            @Override
                            public Integer apply(Number number) {
                                return number.intValue();
                            }
                        };
                        return this._getNumber(value, numberIntegerFunction);
                    }
                    if (rawType.equals(Long.class) || rawType.equals(Long.TYPE)) {
                        Function<Number, Long> numberLongFunction = new Function<Number, Long>(){

                            @Override
                            public Long apply(Number number) {
                                return number.longValue();
                            }
                        };
                        return this._getNumber(value, numberLongFunction);
                    }
                    if (rawType.equals(Double.class) || rawType.equals(Double.TYPE)) {
                        Function<Number, Double> numberDoubleFunction = new Function<Number, Double>(){

                            @Override
                            public Double apply(Number number) {
                                return number.doubleValue();
                            }
                        };
                        return this._getNumber(value, numberDoubleFunction);
                    }
                    if (rawType.equals(Float.class) || rawType.equals(Float.TYPE)) {
                        Function<Number, Float> numberFloatFunction = new Function<Number, Float>(){

                            @Override
                            public Float apply(Number number) {
                                return Float.valueOf(number.floatValue());
                            }
                        };
                        return this._getNumber(value, numberFloatFunction);
                    }
                    if (rawType.equals(Boolean.class) || rawType.equals(Boolean.TYPE)) {
                        if (value == null) {
                            return Boolean.FALSE;
                        }
                        value = value.trim();
                        if (Boolean.valueOf(value = value.toLowerCase()).booleanValue()) {
                            return Boolean.TRUE;
                        }
                        return value.equals("on");
                    }
                    return null;
                }

                private T _getNumber(String value, Function getNumberFunction) {
                    NumberFormat numberFormat = NumberFormat.getInstance(ParamConverterProviderImpl.this.mvcContext.getLocale());
                    try {
                        Number number = numberFormat.parse(value);
                        return getNumberFunction.apply(number);
                    }
                    catch (ParseException pe) {
                        throw new IllegalArgumentException(pe);
                    }
                }

                public String toString(T value) {
                    if (value == null) {
                        return "";
                    }
                    return value.toString();
                }
            };
        }
        return null;
    }

    private String _getParamName(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Class<?> annotationClass = annotation.getClass();
            if (CookieParam.class.isAssignableFrom(annotationClass)) {
                CookieParam cookieParam = (CookieParam)annotation;
                return cookieParam.value();
            }
            if (FormParam.class.isAssignableFrom(annotationClass)) {
                FormParam formParam = (FormParam)annotation;
                return formParam.value();
            }
            if (HeaderParam.class.isAssignableFrom(annotationClass)) {
                HeaderParam headerParam = (HeaderParam)annotation;
                return headerParam.value();
            }
            if (!QueryParam.class.isAssignableFrom(annotationClass)) continue;
            QueryParam queryParam = (QueryParam)annotation;
            return queryParam.value();
        }
        return null;
    }
}

