/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.page.LicensePage;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.renderer.text.AbstractTextPageRenderer;
import org.tp23.antinstaller.renderer.text.Pager;
import org.tp23.antinstaller.runtime.ConfigurationException;

public class LicensePageRenderer
extends AbstractTextPageRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.text.Res");
    private static final String nextChar = res.getString("nextChar");
    private boolean usePaging = false;

    public boolean renderPage(Page page) throws InstallException {
        if (page instanceof LicensePage) {
            LicensePage lPage = (LicensePage)page;
            String strUsePaging = lPage.getUsePaging();
            this.usePaging = strUsePaging != null && this.isTrue(strUsePaging);
            return this.renderLicensePage(lPage);
        }
        throw new InstallException("Wrong Renderer in LicensePageRenderer.renderPage");
    }

    private boolean renderLicensePage(LicensePage page) throws InstallException {
        try {
            BufferedReader commandReader = this.reader;
            this.out.println();
            this.out.println(res.getString("clickViewLicense"));
            commandReader.readLine();
            String resource = page.getResource();
            InputStream licensein = this.getClass().getResourceAsStream(resource);
            if (licensein == null) {
                throw new ConfigurationException("License resource '" + resource + "' is missing from installer");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(licensein));
            this.printHeader(page);
            String lineread = null;
            StringBuffer sb = new StringBuffer();
            while ((lineread = reader.readLine()) != null) {
                sb.append(lineread);
                sb.append('\n');
            }
            reader.close();
            String command = null;
            Pager pager = new Pager(sb.toString());
            if (this.usePaging) {
                while (pager.next(this.out)) {
                    this.out.println();
                    this.out.println(this.getNextInstructions());
                    command = commandReader.readLine();
                    if (command.toUpperCase().startsWith(nextChar)) continue;
                }
                pager.rest(this.out);
            } else {
                this.out.println(pager.getText());
            }
            for (int i = 0; i < 80; ++i) {
                this.out.print('~');
            }
            this.out.println();
            this.out.println(res.getString("licenseAccept"));
            command = commandReader.readLine();
            command = command.trim();
            if (this.isTrue(command)) {
                return true;
            }
            page.setAbort(true);
            return false;
        }
        catch (IOException ex) {
            throw new InstallException("Not able to read license file", ex);
        }
    }

    private String getNextInstructions() {
        return res.getString("license_next");
    }
}

