/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.jsf;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.portals.bridges.jsf.AbstractAttributeMap;

public class ServletRequestHeaderValuesMap
extends AbstractAttributeMap {
    private final HttpServletRequest _httpServletRequest;
    private final Map _valueCache = new HashMap();

    ServletRequestHeaderValuesMap(HttpServletRequest httpServletRequest) {
        this._httpServletRequest = httpServletRequest;
    }

    @Override
    protected Object getAttribute(String key) {
        Object ret = this._valueCache.get(key);
        if (ret == null) {
            ret = this.toArray(this._httpServletRequest.getHeaders(key));
            this._valueCache.put(key, ret);
        }
        return ret;
    }

    @Override
    protected void setAttribute(String key, Object value) {
        throw new UnsupportedOperationException("Cannot set HttpServletRequest HeaderValues");
    }

    @Override
    protected void removeAttribute(String key) {
        throw new UnsupportedOperationException("Cannot remove HttpServletRequest HeaderValues");
    }

    @Override
    protected Enumeration getAttributeNames() {
        return this._httpServletRequest.getHeaderNames();
    }

    private String[] toArray(Enumeration e) {
        ArrayList ret = new ArrayList();
        while (e.hasMoreElements()) {
            ret.add(e.nextElement());
        }
        return ret.toArray(new String[ret.size()]);
    }
}

