/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.jsf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.bridges.jsf.NullIterator;
import org.apache.portals.bridges.jsf.PortletExternalContextImpl;
import org.apache.portals.bridges.jsf.PortletUIViewRoot;

public class PortletFacesContextImpl
extends FacesContext {
    private static final Log log = LogFactory.getLog(PortletFacesContextImpl.class);
    protected static final Object NULL_DUMMY = new Object();
    private List messageClientIds = null;
    private List messages = null;
    private Application application;
    private PortletExternalContextImpl externalContext;
    private ResponseStream responseStream = null;
    private ResponseWriter responseWriter = null;
    private FacesMessage.Severity maximumSeverity = FacesMessage.SEVERITY_INFO;
    private UIViewRoot viewRoot;
    private boolean renderResponse = false;
    private boolean responseComplete = false;
    private RenderKitFactory renderKitFactory;
    public static final String JSF_VIEW_ID = "jsf_viewid";

    public PortletFacesContextImpl(PortletContext portletContext, PortletRequest portletRequest, PortletResponse portletResponse) {
        this.application = ((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication();
        this.renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        this.externalContext = new PortletExternalContextImpl(portletContext, portletRequest, portletResponse);
        FacesContext.setCurrentInstance((FacesContext)this);
    }

    public UIViewRoot resolveViewRoot(String defaultViewName, PortletRequest portletRequest) {
        String requestType;
        PortletRequest request = (PortletRequest)this.externalContext.getRequest();
        String viewId = request.getParameter(JSF_VIEW_ID);
        if (viewId == null) {
            viewId = defaultViewName;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Request view id is null.  Using default view.");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolving view root - Using view id: " + viewId));
        }
        if ((requestType = (String)portletRequest.getAttribute("org.apache.portals.bridges.jsf.request_type")) != null && requestType.equals("ACTION")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resolving action: " + viewId));
            }
            this.setViewRoot(this.viewRoot);
            portletRequest.setAttribute("org.apache.portals.bridges.jsf.REQUEST_SERVLET_PATH", (Object)viewId.replaceAll(".jsp", ".jsf"));
            return null;
        }
        UIViewRoot viewRoot = (UIViewRoot)request.getPortletSession().getAttribute(viewId, 2);
        if (null == viewRoot) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating new view root: " + viewId));
            }
            viewRoot = this.application.getViewHandler().createView((FacesContext)this, viewId);
            PortletUIViewRoot newViewRoot = new PortletUIViewRoot(viewRoot);
            viewRoot = newViewRoot;
            viewRoot.setViewId(viewId);
            viewRoot.setRenderKitId("HTML_BASIC");
            request.getPortletSession().setAttribute(viewId, (Object)viewRoot, 2);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Using view root from session: " + viewId));
        }
        this.setViewRoot(viewRoot);
        portletRequest.setAttribute("org.apache.portals.bridges.jsf.REQUEST_SERVLET_PATH", (Object)viewId.replaceAll(".jsp", ".jsf"));
        return viewRoot;
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public FacesMessage.Severity getMaximumSeverity() {
        return this.maximumSeverity;
    }

    public Iterator getMessages() {
        return this.messages != null ? this.messages.iterator() : Collections.EMPTY_LIST.iterator();
    }

    public Application getApplication() {
        return this.application;
    }

    public Iterator getClientIdsWithMessages() {
        if (this.messages == null || this.messages.isEmpty()) {
            return NullIterator.instance();
        }
        return new Iterator(){
            private int next;
            boolean nextFound;

            @Override
            public void remove() {
                throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
            }

            @Override
            public boolean hasNext() {
                if (!this.nextFound) {
                    int len = PortletFacesContextImpl.this.messageClientIds.size();
                    while (this.next < len) {
                        if (PortletFacesContextImpl.this.messageClientIds.get(this.next) != NULL_DUMMY) {
                            this.nextFound = true;
                            break;
                        }
                        ++this.next;
                    }
                }
                return this.nextFound;
            }

            public Object next() {
                if (this.hasNext()) {
                    this.nextFound = false;
                    return PortletFacesContextImpl.this.messageClientIds.get(this.next++);
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Iterator getMessages(String clientId) {
        if (this.messages == null) {
            return NullIterator.instance();
        }
        ArrayList lst = new ArrayList();
        for (int i = 0; i < this.messages.size(); ++i) {
            Object savedClientId = this.messageClientIds.get(i);
            if (clientId == null) {
                if (savedClientId != NULL_DUMMY) continue;
                lst.add(this.messages.get(i));
                continue;
            }
            if (!clientId.equals(savedClientId)) continue;
            lst.add(this.messages.get(i));
        }
        return lst.iterator();
    }

    public RenderKit getRenderKit() {
        if (this.getViewRoot() == null) {
            return null;
        }
        String renderKitId = this.getViewRoot().getRenderKitId();
        if (renderKitId == null) {
            return null;
        }
        return this.renderKitFactory.getRenderKit((FacesContext)this, renderKitId);
    }

    public boolean getRenderResponse() {
        return this.renderResponse;
    }

    public boolean getResponseComplete() {
        return this.responseComplete;
    }

    public void setResponseStream(ResponseStream responseStream) {
        if (responseStream == null) {
            throw new NullPointerException("responseStream");
        }
        this.responseStream = responseStream;
    }

    public ResponseStream getResponseStream() {
        return this.responseStream;
    }

    public void setResponseWriter(ResponseWriter responseWriter) {
        if (responseWriter == null) {
            throw new NullPointerException("responseWriter");
        }
        this.responseWriter = responseWriter;
    }

    public ResponseWriter getResponseWriter() {
        return this.responseWriter;
    }

    public void setViewRoot(UIViewRoot viewRoot) {
        if (viewRoot == null) {
            throw new NullPointerException("viewRoot");
        }
        this.viewRoot = viewRoot;
    }

    public UIViewRoot getViewRoot() {
        return this.viewRoot;
    }

    public void addMessage(String clientId, FacesMessage message) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (this.messages == null) {
            this.messages = new ArrayList();
            this.messageClientIds = new ArrayList();
        }
        this.messages.add(message);
        this.messageClientIds.add(clientId != null ? clientId : NULL_DUMMY);
        FacesMessage.Severity serSeverity = message.getSeverity();
        if (serSeverity != null && serSeverity.compareTo((Object)this.maximumSeverity) > 0) {
            this.maximumSeverity = message.getSeverity();
        }
    }

    public void release() {
        if (this.externalContext != null) {
            this.externalContext.release();
            this.externalContext = null;
        }
        this.messageClientIds = null;
        this.messages = null;
        this.application = null;
        this.responseStream = null;
        this.responseWriter = null;
        this.viewRoot = null;
        FacesContext.setCurrentInstance(null);
    }

    public void renderResponse() {
        this.renderResponse = true;
    }

    public void responseComplete() {
        this.responseComplete = true;
    }
}

