/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.jsf;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.bridges.jsf.ApplicationMap;
import org.apache.portals.bridges.jsf.EnumerationIterator;
import org.apache.portals.bridges.jsf.InitParameterMap;
import org.apache.portals.bridges.jsf.RequestHeaderMap;
import org.apache.portals.bridges.jsf.RequestHeaderValuesMap;
import org.apache.portals.bridges.jsf.RequestMap;
import org.apache.portals.bridges.jsf.RequestParameterMap;
import org.apache.portals.bridges.jsf.RequestParameterValuesMap;
import org.apache.portals.bridges.jsf.SessionMap;

public class PortletExternalContextImpl
extends ExternalContext {
    private static final Log log = LogFactory.getLog(PortletExternalContextImpl.class);
    private static final String INIT_PARAMETER_MAP_ATTRIBUTE = InitParameterMap.class.getName();
    private PortletContext portletContext;
    private PortletRequest portletRequest;
    private PortletResponse portletResponse;
    private Map applicationMap;
    private Map sessionMap;
    private Map requestMap;
    private Map requestParameterMap;
    private Map requestParameterValuesMap;
    private Map requestHeaderMap;
    private Map requestHeaderValuesMap;
    private Map requestCookieMap;
    private Map initParameterMap;
    private String requestPathInfo;
    private String requestServletPath;

    public PortletExternalContextImpl(PortletContext portletContext, PortletRequest portletRequest, PortletResponse portletResponse) {
        this.portletContext = portletContext;
        this.portletRequest = portletRequest;
        this.portletResponse = portletResponse;
        this.applicationMap = null;
        this.sessionMap = null;
        this.requestMap = null;
        this.requestParameterMap = null;
        this.requestParameterValuesMap = null;
        this.requestHeaderMap = null;
        this.requestHeaderValuesMap = null;
        this.requestCookieMap = null;
        this.initParameterMap = null;
        this.requestPathInfo = null;
        this.requestServletPath = null;
    }

    public void release() {
        this.portletContext = null;
        this.portletRequest = null;
        this.portletResponse = null;
        this.applicationMap = null;
        this.sessionMap = null;
        this.requestMap = null;
        this.requestParameterMap = null;
        this.requestParameterValuesMap = null;
        this.requestHeaderMap = null;
        this.requestHeaderValuesMap = null;
        this.requestCookieMap = null;
        this.initParameterMap = null;
        this.requestPathInfo = null;
        this.requestServletPath = null;
    }

    public Object getSession(boolean create) {
        return this.portletRequest.getPortletSession(create);
    }

    public Object getContext() {
        return this.portletContext;
    }

    public Object getRequest() {
        return this.portletRequest;
    }

    public Object getResponse() {
        return this.portletResponse;
    }

    public Map getApplicationMap() {
        if (this.applicationMap == null) {
            this.applicationMap = new ApplicationMap(this.portletContext);
        }
        return this.applicationMap;
    }

    public Map getSessionMap() {
        if (this.sessionMap == null) {
            this.sessionMap = new SessionMap(this.portletRequest);
        }
        return this.sessionMap;
    }

    public Map getRequestMap() {
        if (this.requestMap == null) {
            this.requestMap = new RequestMap(this.portletRequest);
        }
        return this.requestMap;
    }

    public Map getRequestParameterMap() {
        if (this.requestParameterMap == null) {
            this.requestParameterMap = new RequestParameterMap(this.portletRequest);
        }
        return this.requestParameterMap;
    }

    public Map getRequestParameterValuesMap() {
        if (this.requestParameterValuesMap == null) {
            this.requestParameterValuesMap = new RequestParameterValuesMap(this.portletRequest);
        }
        return this.requestParameterValuesMap;
    }

    public Iterator getRequestParameterNames() {
        final Enumeration names = this.portletRequest.getParameterNames();
        Iterator it = new Iterator(){

            @Override
            public boolean hasNext() {
                return names.hasMoreElements();
            }

            public Object next() {
                return names.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
            }
        };
        return it;
    }

    public Map getRequestHeaderMap() {
        if (this.requestHeaderMap == null) {
            this.requestHeaderMap = new RequestHeaderMap(this.portletRequest);
        }
        return this.requestHeaderMap;
    }

    public Map getRequestHeaderValuesMap() {
        if (this.requestHeaderValuesMap == null) {
            this.requestHeaderValuesMap = new RequestHeaderValuesMap(this.portletRequest);
        }
        return this.requestHeaderValuesMap;
    }

    public Map getRequestCookieMap() {
        return null;
    }

    public Locale getRequestLocale() {
        return this.portletRequest.getLocale();
    }

    public String getRequestPathInfo() {
        return null;
    }

    public String getRequestContextPath() {
        return this.portletRequest.getContextPath();
    }

    public String getInitParameter(String s) {
        return this.portletContext.getInitParameter(s);
    }

    public Map getInitParameterMap() {
        if (this.initParameterMap == null && (this.initParameterMap = (Map)this.portletContext.getAttribute(INIT_PARAMETER_MAP_ATTRIBUTE)) == null) {
            this.initParameterMap = new InitParameterMap(this.portletContext);
            this.portletContext.setAttribute(INIT_PARAMETER_MAP_ATTRIBUTE, (Object)this.initParameterMap);
        }
        return this.initParameterMap;
    }

    public Set getResourcePaths(String s) {
        return this.portletContext.getResourcePaths(s);
    }

    public InputStream getResourceAsStream(String s) {
        return this.portletContext.getResourceAsStream(s);
    }

    public String encodeActionURL(String s) {
        if (null != s && (s.startsWith("http") || s.startsWith("/"))) {
            return this.portletResponse.encodeURL(s);
        }
        return s;
    }

    public String encodeResourceURL(String s) {
        if (null != s && (s.startsWith("http") || s.startsWith("/"))) {
            return this.portletResponse.encodeURL(s);
        }
        return s;
    }

    public String encodeNamespace(String pNamespace) {
        String vRetEncodedNamespace = null;
        if (!(this.portletResponse instanceof RenderResponse)) {
            throw new IllegalArgumentException("Only RenderResponse can be used to encode namespace");
        }
        vRetEncodedNamespace = ((RenderResponse)this.portletResponse).getNamespace() + pNamespace;
        return vRetEncodedNamespace;
    }

    public void dispatch(String requestURI) throws IOException, FacesException {
        if (!(this.portletResponse instanceof RenderResponse)) {
            throw new IllegalArgumentException("Only RenderResponse can be dispatched");
        }
        if (!(this.portletRequest instanceof RenderRequest)) {
            throw new IllegalArgumentException("Only RenderRequest can be dispatched");
        }
        PortletRequestDispatcher portletRequestDispatcher = this.portletContext.getRequestDispatcher(requestURI);
        try {
            portletRequestDispatcher.include((RenderRequest)this.portletRequest, (RenderResponse)this.portletResponse);
        }
        catch (PortletException e) {
            if (e.getMessage() != null) {
                throw new FacesException(e.getMessage(), (Throwable)e);
            }
            throw new FacesException((Throwable)e);
        }
    }

    public String getRequestServletPath() {
        return (String)this.portletRequest.getAttribute("org.apache.portals.bridges.jsf.REQUEST_SERVLET_PATH");
    }

    public String getAuthType() {
        return this.portletRequest.getAuthType();
    }

    public String getRemoteUser() {
        return this.portletRequest.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.portletRequest.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.portletRequest.getUserPrincipal();
    }

    public void log(String message) {
        this.portletContext.log(message);
    }

    public void log(String message, Throwable t) {
        this.portletContext.log(message, t);
    }

    public void redirect(String url) throws IOException {
        if (!(this.portletResponse instanceof ActionResponse)) {
            throw new IOException("Cannot redirect from render phase");
        }
        ActionResponse r = (ActionResponse)this.portletResponse;
        r.sendRedirect(url);
    }

    public Iterator getRequestLocales() {
        return new EnumerationIterator(this.portletRequest.getLocales());
    }

    public URL getResource(String s) throws MalformedURLException {
        return this.portletContext.getResource(s);
    }
}

