/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.w3c.dom.*;

import static org.junit.jupiter.api.Assertions.*;
import static org.w3c.domts.DOMTest.isExpandEntityReferences;
import static org.w3c.domts.DOMTest.load;


/**
 * The "setAttributeNS(namespaceURI,qualifiedName,value)" method for an attribute causes the
 * DOMException NO_MODIFICATION_ALLOWED_ERR to be raised
 * if the node is readonly.
 * <p>
 * Obtain the children of the THIRD "gender" element.  The elements
 * content is an entity reference.  Try to set an attribute
 * in the entity reference by executing the
 * "setAttributeNS(namespaceURI,qualifiedName,value)" method.
 * This causes a NO_MODIFICATION_ALLOWED_ERR DOMException to be thrown.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-258A00AF')/constant[@name='NO_MODIFICATION_ALLOWED_ERR'])">http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-258A00AF')/constant[@name='NO_MODIFICATION_ALLOWED_ERR'])</a>
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAttrNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAttrNS</a>
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-ElSetAttrNS')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NO_MODIFICATION_ALLOWED_ERR'])">http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-ElSetAttrNS')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NO_MODIFICATION_ALLOWED_ERR'])</a>
 */
public class setAttributeNS03 {
    @Test
    @Disabled
    public void testRun() throws Throwable {
        String namespaceURI = "www.xyz.com";
        String qualifiedName = "emp:local1";
        Document doc = load("staffNS", true);

        Node gen;
        if (!isExpandEntityReferences()) {
            NodeList genderList = doc.getElementsByTagName("gender");
            //ykadiysk: item(2) is an empty gender element: it has no child nodes.
            //  Changing it to 1
            //gender = genderList.item(1);
            gen = genderList.item(1);
            //ykadiysk: This makes no sense: a gender elt only has a text child
            //the test seemed to be looking for some deep structure underneath
            // genList = gender.getChildNodes();
            // gen = genList.item(0);
        } else {
            gen = doc.createEntityReference("ent4");
        }

        NodeList gList = gen.getChildNodes();

        Element genElement = (Element) gList.item(0);
        assertNotNull(genElement, "notnull");

        DOMException ex = assertThrows(DOMException.class, () -> genElement.setAttributeNS(namespaceURI, qualifiedName, "newValue"));
        assertEquals(DOMException.NO_MODIFICATION_ALLOWED_ERR, ex.code, "throw_NO_MODIFICATION_ALLOWED_ERR");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/setAttributeNS03";
    }

}
