/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.w3c.domts.DOMTest.load;


/**
 * The method setAttributeNS adds a new attribute and raises a NAMESPACE_ERR
 * if the qualifiedName, or its prefix, is "xmlns" and the namespaceURI is
 * different from "http://www.w3.org/2000/xmlns/".
 * Invoke the setAttributeNS method on a new Element object with namespaceURI that is
 * http://www.w3.org/DOMTest/level2 and a qualifiedName that has the prefix xmlns and once
 * again with a qualifiedName that is xmlns.
 * Check if the NAMESPACE_ERR was thrown.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAttrNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAttrNS</a>
 */
public class elementsetattributens08 {
    @Test
    void testRun() throws Throwable {
        Document doc = load("staffNS", true);
        String nsURI = "http://www.w3.org/DOMTest/level2";
        Element element = doc.createElementNS(nsURI, "dom:elem");

        DOMException ex1 = assertThrows(DOMException.class, () -> element.setAttributeNS(nsURI, "xmlns", "test"));
        assertEquals(DOMException.NAMESPACE_ERR, ex1.code, "elementsetattributens08_Err1");

        DOMException ex2 = assertThrows(DOMException.class, () -> element.setAttributeNS(nsURI, "xmlns:root", "test"));
        assertEquals(DOMException.NAMESPACE_ERR, ex2.code, "elementsetattributens08_Err2");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/elementsetattributens08";
    }

}
