/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10;

import com.fasterxml.jackson.databind.JsonNode;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.DataSet;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.Source;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.TypeaheadConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.TypeaheadEvent;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.TypeaheadJsReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.bloodhound.Bloodhound;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.JQuery;
import de.agilecoders.wicket.jquery.util.Json;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.ResourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Typeahead<T>
extends TextField<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(Typeahead.class);
    private final TypeaheadConfig config;
    private TypeaheadBehavior selectBehavior;

    public Typeahead(String id, IModel<T> model, TypeaheadConfig config) {
        super(id, model);
        this.config = config;
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        for (DataSet dataSet : this.config.getDatasets()) {
            Source source = dataSet.getSource();
            if (source instanceof Behavior) {
                Behavior behavior = (Behavior)source;
                if (!this.getBehaviors().contains(behavior)) {
                    this.add(new Behavior[]{behavior});
                }
            }
            dataSet.withSource(source);
        }
        if (this.selectBehavior == null && this.config.isSelectEvent()) {
            Behavior[] behaviorArray = new Behavior[1];
            this.selectBehavior = new TypeaheadBehavior(TypeaheadEvent.Type.SELECTED);
            behaviorArray[0] = this.selectBehavior;
            this.add(behaviorArray);
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render(this.newTypeaheadJsHeaderItem());
        response.render((HeaderItem)this.getDomReadyScript(this.config));
    }

    protected HeaderItem newTypeaheadJsHeaderItem() {
        return JavaScriptHeaderItem.forReference((ResourceReference)TypeaheadJsReference.instance());
    }

    public OnDomReadyHeaderItem getDomReadyScript(TypeaheadConfig config) {
        StringBuilder builder = new StringBuilder();
        for (DataSet dataSet : config.getDatasets()) {
            if (!(dataSet.getSource() instanceof Bloodhound)) continue;
            Bloodhound bh = (Bloodhound)dataSet.getSource();
            String bhParams = bh.getConfig().isEmpty() ? "" : bh.getConfig().toJsonString();
            builder.append(String.format("var %s = new Bloodhound(%s);", bh.getName(), bhParams));
            builder.append(String.format("%s.initialize();", bh.getName()));
        }
        JQuery functionCall = JQuery.$((Component)this).chain((CharSequence)"typeahead", (Config)config, config.getDatasets());
        builder.append(functionCall.get());
        if (this.selectBehavior != null) {
            CharSequence function = this.selectBehavior.getCallbackFunction(new CallbackParameter[]{CallbackParameter.context((String)"object"), CallbackParameter.converted((String)"datum", (String)"JSON.stringify(datum)"), CallbackParameter.explicit((String)"name")});
            builder.append(String.format("$('#%s').bind('typeahead:selected', %s);", this.getMarkupId(), function));
        }
        return OnDomReadyHeaderItem.forScript((CharSequence)builder.toString());
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "input");
        this.checkComponentTagAttribute(tag, "type", new String[]{"text"});
        tag.put("autocomplete", (CharSequence)"off");
    }

    private static class TypeaheadBehavior
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;
        private final TypeaheadEvent.Type type;

        public TypeaheadBehavior(TypeaheadEvent.Type type) {
            this.type = type;
        }

        protected void respond(AjaxRequestTarget target) {
            RequestCycle requestCycle = this.getComponent().getRequestCycle();
            Request request = requestCycle.getRequest();
            IRequestParameters parameters = request.getRequestParameters();
            Component component = this.getComponent();
            try {
                JsonNode jsonNode = Json.parse((String)parameters.getParameterValue("datum").toString());
                component.send((IEventSink)component.getPage(), Broadcast.BREADTH, (Object)new TypeaheadEvent(this.type, jsonNode));
            }
            catch (IllegalStateException ise) {
                LOG.warn("Unable to get page for sending typeahead event");
            }
            catch (Json.ParseException pe) {
                LOG.warn("Unable to parse selected typeahead datum");
            }
        }
    }
}

