/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.cluster.Member;
import com.hazelcast.jet.RestartableException;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.version.Version;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CoreQueryUtils {
    private CoreQueryUtils() {
    }

    public static HazelcastSqlException toPublicException(@Nonnull Throwable e, @Nonnull UUID localMemberId) {
        if (e instanceof HazelcastSqlException) {
            HazelcastSqlException exception = (HazelcastSqlException)e;
            return exception;
        }
        if (e instanceof QueryException) {
            QueryException e0 = (QueryException)e;
            UUID originatingMemberId = e0.getOriginatingMemberId();
            if (originatingMemberId == null) {
                originatingMemberId = localMemberId;
            }
            return new HazelcastSqlException(originatingMemberId, e0.getCode(), e0.getMessage(), e, e0.getSuggestion());
        }
        for (Throwable copy = e; copy != null; copy = copy.getCause()) {
            if (ExceptionUtil.isTopologyException(copy)) {
                return new HazelcastSqlException(localMemberId, 1011, e.getMessage(), e, null);
            }
            if (!(copy instanceof RestartableException)) continue;
            return new HazelcastSqlException(localMemberId, 1012, e.getMessage(), e, null);
        }
        return new HazelcastSqlException(localMemberId, -1, e.getMessage(), e, null);
    }

    @Nullable
    public static Member memberOfLargerSameVersionGroup(@Nonnull Collection<Member> members, @Nullable Member localMember) {
        Version version;
        int count;
        Version version0 = null;
        Version version1 = null;
        int count0 = 0;
        int count1 = 0;
        int grossMajority = members.size() / 2;
        for (Member m : members) {
            int currentCount;
            if (m.isLiteMember()) continue;
            Version v = m.getVersion().asVersion();
            if (version0 == null || version0.equals(v)) {
                version0 = v;
                currentCount = ++count0;
            } else if (version1 == null || version1.equals(v)) {
                version1 = v;
                currentCount = ++count1;
            } else {
                throw new RuntimeException("More than 2 distinct member versions found: " + version0 + ", " + version1 + ", " + v);
            }
            if (currentCount <= grossMajority || localMember == null || !localMember.getVersion().asVersion().equals(v)) continue;
            return localMember;
        }
        assert (count1 == 0 || count0 > 0);
        if (count0 == 0) {
            return null;
        }
        if (count0 > count1 || count0 == count1 && version0.compareTo(version1) > 0) {
            count = count0;
            version = version0;
        } else {
            count = count1;
            version = version1;
        }
        if (localMember != null && !localMember.isLiteMember() && localMember.getVersion().asVersion().equals(version)) {
            return localMember;
        }
        int randomMemberIndex = ThreadLocalRandom.current().nextInt(count);
        for (Member m : members) {
            if (m.isLiteMember() || !m.getVersion().asVersion().equals(version) || --randomMemberIndex >= 0) continue;
            return m;
        }
        throw new RuntimeException("should never get here");
    }
}

