/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.server;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.List;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.entity.server.LdapConfig;
import org.apache.openmeetings.db.entity.server.OAuthServer;
import org.apache.openmeetings.db.util.DaoHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class OAuth2Dao
implements IDataProviderDao<OAuthServer> {
    private static final List<String> searchFields = List.of("name");
    @PersistenceContext
    private EntityManager em;
    @Inject
    private ConfigurationDao cfgDao;

    public List<OAuthServer> getActive() {
        if (!OpenmeetingsVariables.isAllowRegisterOauth()) {
            return List.of();
        }
        return this.em.createNamedQuery("getEnabledOAuthServers", OAuthServer.class).getResultList();
    }

    @Override
    public OAuthServer get(Long id) {
        return (OAuthServer)DaoHelper.only(this.em.createNamedQuery("getOAuthServerById", OAuthServer.class).setParameter("id", (Object)id).getResultList());
    }

    @Override
    public List<OAuthServer> get(long start, long count) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getAllOAuthServers", OAuthServer.class), start, count).getResultList();
    }

    @Override
    public List<OAuthServer> get(String search, long start, long count, SortParam<String> sort) {
        return DaoHelper.get(this.em, OAuthServer.class, false, search, searchFields, true, null, sort, start, count);
    }

    @Override
    public long count() {
        return (Long)this.em.createNamedQuery("countOAuthServers", Long.class).getSingleResult();
    }

    @Override
    public long count(String search) {
        return DaoHelper.count(this.em, LdapConfig.class, search, searchFields, true, null);
    }

    @Override
    public OAuthServer update(OAuthServer server, Long userId) {
        if (server.getId() == null) {
            this.em.persist((Object)server);
        } else {
            server = (OAuthServer)this.em.merge((Object)server);
        }
        this.cfgDao.updateCsp();
        return server;
    }

    @Override
    public void delete(OAuthServer server, Long userId) {
        server.setDeleted(true);
        this.update(server, userId);
    }
}

