/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import java.security.AccessController;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.MessageInterpolator;
import org.apache.bval.el.MessageEvaluator;
import org.apache.bval.jsr.DefaultMessageInterpolator$org_apache_bval_util_reflection_Reflection$$getClassLoader$$Ljava_lang_Class$_ACTION;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilized;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
@Privilized(value="DYNAMIC")
public class DefaultMessageInterpolator
implements MessageInterpolator {
    private static final Logger log;
    private static final boolean LOG_FINEST;
    private static final String DEFAULT_VALIDATION_MESSAGES = "org.apache.bval.jsr.ValidationMessages";
    private static final String USER_VALIDATION_MESSAGES = "ValidationMessages";
    private static final Pattern messageParameterPattern;
    private Locale defaultLocale;
    private final Map<Locale, ResourceBundle> userBundlesMap = new ConcurrentHashMap<Locale, ResourceBundle>();
    private final Map<Locale, ResourceBundle> defaultBundlesMap = new ConcurrentHashMap<Locale, ResourceBundle>();
    private final MessageEvaluator evaluator;

    public DefaultMessageInterpolator() {
        this(null);
    }

    public DefaultMessageInterpolator(ResourceBundle resourceBundle) {
        this.defaultLocale = Locale.getDefault();
        this.findDefaultResourceBundle(this.defaultLocale);
        if (resourceBundle == null) {
            this.findUserResourceBundle(this.defaultLocale);
        } else {
            this.userBundlesMap.put(this.defaultLocale, resourceBundle);
        }
        MessageEvaluator ev = null;
        try {
            ev = (MessageEvaluator)MessageEvaluator.class.cast(this.getClass().getClassLoader().loadClass("org.apache.bval.el.ELFacade").newInstance());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.evaluator = ev;
    }

    public String interpolate(String message, MessageInterpolator.Context context) {
        return this.interpolate(message, context, this.defaultLocale);
    }

    public String interpolate(String message, MessageInterpolator.Context context, Locale locale) {
        return this.interpolateMessage(message, context.getConstraintDescriptor().getAttributes(), locale, context.getValidatedValue());
    }

    private String interpolateMessage(String message, Map<String, Object> annotationParameters, Locale locale, Object validatedValue) {
        ResourceBundle userResourceBundle = this.findUserResourceBundle(locale);
        ResourceBundle defaultResourceBundle = this.findDefaultResourceBundle(locale);
        String resolvedMessage = message;
        boolean evaluatedDefaultBundleOnce = false;
        while (true) {
            String userBundleResolvedMessage = this.replaceVariables(resolvedMessage, userResourceBundle, locale, true);
            if (evaluatedDefaultBundleOnce && !this.hasReplacementTakenPlace(userBundleResolvedMessage, resolvedMessage)) break;
            resolvedMessage = this.replaceVariables(userBundleResolvedMessage, defaultResourceBundle, locale, false);
            evaluatedDefaultBundleOnce = true;
        }
        resolvedMessage = this.replaceAnnotationAttributes(resolvedMessage, annotationParameters);
        if (this.evaluator != null) {
            resolvedMessage = this.evaluator.interpolate(resolvedMessage, annotationParameters, validatedValue);
        }
        resolvedMessage = resolvedMessage.replace("\\{", "{").replace("\\}", "}").replace("\\\\", "\\").replace("\\$", "$");
        return resolvedMessage;
    }

    private boolean hasReplacementTakenPlace(String origMessage, String newMessage) {
        return !origMessage.equals(newMessage);
    }

    private ResourceBundle getFileBasedResourceBundle(Locale locale) {
        ResourceBundle rb = null;
        ClassLoader classLoader = DefaultMessageInterpolator.org_apache_bval_util_reflection_Reflection$$getClassLoader(DefaultMessageInterpolator.class);
        if (classLoader != null) {
            rb = this.loadBundle(classLoader, locale, "ValidationMessages not found by thread local classloader");
        }
        if (rb == null) {
            rb = this.loadBundle(this.getClass().getClassLoader(), locale, "ValidationMessages not found by validator classloader");
        }
        if (LOG_FINEST) {
            if (rb != null) {
                log.log(Level.FINEST, String.format("%s found", USER_VALIDATION_MESSAGES));
            } else {
                log.log(Level.FINEST, String.format("%s not found. Delegating to %s", USER_VALIDATION_MESSAGES, DEFAULT_VALIDATION_MESSAGES));
            }
        }
        return rb;
    }

    @Privileged
    private static /* synthetic */ ClassLoader org_apache_bval_util_reflection_Reflection$$getClassLoader(Class<?> clazz) {
        if (!(System.getSecurityManager() != null)) {
            return DefaultMessageInterpolator.__privileged_org_apache_bval_util_reflection_Reflection$$getClassLoader(clazz);
        }
        return (ClassLoader)AccessController.doPrivileged(new DefaultMessageInterpolator$org_apache_bval_util_reflection_Reflection$$getClassLoader$$Ljava_lang_Class$_ACTION(clazz));
    }

    static /* synthetic */ ClassLoader __privileged_access$0(Class clazz) {
        return DefaultMessageInterpolator.__privileged_org_apache_bval_util_reflection_Reflection$$getClassLoader(clazz);
    }

    private static /* synthetic */ ClassLoader __privileged_org_apache_bval_util_reflection_Reflection$$getClassLoader(Class<?> clazz) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader == null ? clazz.getClassLoader() : classLoader;
    }

    private ResourceBundle loadBundle(ClassLoader classLoader, Locale locale, String message) {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(USER_VALIDATION_MESSAGES, locale, classLoader);
        }
        catch (MissingResourceException e) {
            log.fine(message);
        }
        return rb;
    }

    private String replaceVariables(String message, ResourceBundle bundle, Locale locale, boolean recurse) {
        Matcher matcher = messageParameterPattern.matcher(message);
        StringBuffer sb = new StringBuffer(64);
        while (matcher.find()) {
            String parameter = matcher.group(1);
            String resolvedParameterValue = this.resolveParameter(parameter, bundle, locale, recurse);
            matcher.appendReplacement(sb, this.sanitizeForAppendReplacement(resolvedParameterValue));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String replaceAnnotationAttributes(String message, Map<String, Object> annotationParameters) {
        Matcher matcher = messageParameterPattern.matcher(message);
        StringBuffer sb = new StringBuffer(64);
        while (matcher.find()) {
            String parameter = matcher.group(1);
            Object variable = annotationParameters.get(this.removeCurlyBrace(parameter));
            String resolvedParameterValue = variable != null ? (variable.getClass().isArray() ? Arrays.toString((Object[])variable) : variable.toString()) : parameter;
            matcher.appendReplacement(sb, this.sanitizeForAppendReplacement(resolvedParameterValue));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String resolveParameter(String parameterName, ResourceBundle bundle, Locale locale, boolean recurse) {
        String parameterValue;
        try {
            if (bundle != null) {
                parameterValue = bundle.getString(this.removeCurlyBrace(parameterName));
                if (recurse) {
                    parameterValue = this.replaceVariables(parameterValue, bundle, locale, recurse);
                }
            } else {
                parameterValue = parameterName;
            }
        }
        catch (MissingResourceException e) {
            parameterValue = parameterName;
        }
        return parameterValue;
    }

    private String removeCurlyBrace(String parameter) {
        return parameter.substring(1, parameter.length() - 1);
    }

    private ResourceBundle findDefaultResourceBundle(Locale locale) {
        ResourceBundle bundle = this.defaultBundlesMap.get(locale);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(DEFAULT_VALIDATION_MESSAGES, locale);
            this.defaultBundlesMap.put(locale, bundle);
        }
        return bundle;
    }

    private ResourceBundle findUserResourceBundle(Locale locale) {
        ResourceBundle bundle = this.userBundlesMap.get(locale);
        if (bundle == null && (bundle = this.getFileBasedResourceBundle(locale)) != null) {
            this.userBundlesMap.put(locale, bundle);
        }
        return bundle;
    }

    public void setLocale(Locale locale) {
        this.defaultLocale = locale;
    }

    private String sanitizeForAppendReplacement(String src) {
        return src.replace("\\", "\\\\").replace("$", "\\$");
    }

    private static void __privileged_clinit0() {
        log = Logger.getLogger(DefaultMessageInterpolator.class.getName());
        LOG_FINEST = log.isLoggable(Level.FINEST);
        messageParameterPattern = Pattern.compile("(\\{[\\w\\.]+\\})");
    }

    static {
        DefaultMessageInterpolator.__privileged_clinit0();
    }
}

