/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import lombok.Generated;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;

public class MergeUtils {
    @Generated
    private static final Log LOG = LogFactory.getLog(MergeUtils.class);

    public static <T> T merge(T a, T b) {
        return b != null ? b : a;
    }

    public static <E, T extends Collection<E>> T merge(T a, T b) {
        return a == null ? b : (b != null && !b.isEmpty() ? b : a);
    }

    public static <K, V> Map<K, V> merge(Map<K, V> primary, Map<K, V> overrides, BiFunction<V, V, V> mergeFn) {
        if (primary == null) {
            return overrides;
        }
        HashMap<K, V> result = new HashMap<K, V>(primary);
        if (overrides != null) {
            for (K key : overrides.keySet()) {
                if (primary.containsKey(key)) {
                    V mergedValue = mergeFn.apply(primary.get(key), overrides.get(key));
                    result.replace(key, mergedValue);
                    continue;
                }
                result.put(key, mergeFn.apply(overrides.get(key), overrides.get(key)));
            }
        }
        return result;
    }

    public static Object mergeObjects(Object primary, Object override) {
        if (primary instanceof Map && override instanceof Map) {
            return MergeUtils.mergeMaps((Map)primary, (Map)override);
        }
        return override != null ? override : primary;
    }

    private static Map<?, ?> mergeMaps(Map<?, ?> primary, Map<?, ?> overrides) {
        if (primary == null) {
            return overrides;
        }
        if (overrides == null) {
            return primary;
        }
        HashMap result = new HashMap();
        Stream.concat(primary.keySet().stream(), overrides.keySet().stream()).distinct().forEach(key -> {
            Object primaryValue = primary.get(key);
            Object overrideValue = overrides.get(key);
            if (primaryValue instanceof Map && overrideValue instanceof Map) {
                result.put(key, MergeUtils.mergeMaps((Map)primaryValue, (Map)overrideValue));
            } else {
                result.put(key, overrideValue != null ? overrideValue : primaryValue);
            }
        });
        return result;
    }

    public static <T> void mergeModel(T source, T target) {
        Class<?> clas = source.getClass();
        Field[] fields = clas.getDeclaredFields();
        try {
            for (Field field : fields) {
                if (Modifier.isFinal(field.getModifiers())) continue;
                field.setAccessible(true);
                Object sourceValue = field.get(source);
                Object targetValue = field.get(target);
                Object value = sourceValue != null ? sourceValue : targetValue;
                field.set(target, value);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to get value from field when merging model", e);
        }
    }
}

