/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.encrypt;

import java.util.Objects;
import javax.crypto.SecretKey;
import org.apache.nifi.encrypt.EncryptionException;
import org.apache.nifi.encrypt.KeyedCipherPropertyEncryptor;
import org.apache.nifi.encrypt.PropertyEncryptionMethod;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.encrypt.PropertySecretKeyProvider;
import org.apache.nifi.encrypt.StandardPropertySecretKeyProvider;

public class PropertyEncryptorBuilder {
    private static final PropertySecretKeyProvider SECRET_KEY_PROVIDER = new StandardPropertySecretKeyProvider();
    private final String password;
    private String algorithm = PropertyEncryptionMethod.NIFI_ARGON2_AES_GCM_256.toString();

    public PropertyEncryptorBuilder(String password) {
        Objects.requireNonNull(password, "Password required");
        this.password = password;
    }

    public PropertyEncryptorBuilder setAlgorithm(String algorithm) {
        Objects.requireNonNull(algorithm, "Algorithm required");
        this.algorithm = algorithm;
        return this;
    }

    public PropertyEncryptor build() {
        PropertyEncryptionMethod propertyEncryptionMethod = this.findPropertyEncryptionAlgorithm(this.algorithm);
        SecretKey secretKey = SECRET_KEY_PROVIDER.getSecretKey(propertyEncryptionMethod, this.password);
        return new KeyedCipherPropertyEncryptor(secretKey);
    }

    private PropertyEncryptionMethod findPropertyEncryptionAlgorithm(String algorithm) {
        PropertyEncryptionMethod foundPropertyEncryptionMethod = null;
        for (PropertyEncryptionMethod propertyEncryptionMethod : PropertyEncryptionMethod.values()) {
            if (!propertyEncryptionMethod.toString().equals(algorithm)) continue;
            foundPropertyEncryptionMethod = propertyEncryptionMethod;
            break;
        }
        if (foundPropertyEncryptionMethod == null) {
            String message = String.format("Algorithm [%s] not supported for Sensitive Properties", algorithm);
            throw new EncryptionException(message);
        }
        return foundPropertyEncryptionMethod;
    }
}

