/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.base;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.SchemaObject;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.JdbcUtils;

public abstract class Table<D extends Database, S extends Schema>
extends SchemaObject<D, S> {
    protected int lockDepth = 0;

    public Table(JdbcTemplate jdbcTemplate, D database, S schema, String name) {
        super(jdbcTemplate, database, schema, name);
    }

    public boolean exists() {
        try {
            return this.doExists();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to check whether table " + String.valueOf(this) + " exists", e);
        }
    }

    protected abstract boolean doExists() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean exists(Schema catalog, Schema schema, String table, String ... tableTypes) throws SQLException {
        boolean found;
        String[] types = tableTypes;
        if (types.length == 0) {
            types = null;
        }
        ResultSet resultSet = null;
        try {
            resultSet = this.database.jdbcMetaData.getTables(catalog == null ? null : catalog.getName(), schema == null ? null : schema.getName(), table, types);
            found = resultSet.next();
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        return found;
    }

    public void lock() {
        if (!this.exists()) {
            return;
        }
        try {
            this.doLock();
            ++this.lockDepth;
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to lock table " + String.valueOf(this), e);
        }
    }

    protected abstract void doLock() throws SQLException;

    public void unlock() {
        if (!this.exists() || this.lockDepth == 0) {
            return;
        }
        try {
            this.doUnlock();
            --this.lockDepth;
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to unlock table " + String.valueOf(this), e);
        }
    }

    protected void doUnlock() throws SQLException {
    }
}

