/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.provider.extension;

import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.registry.extension.BundlePersistenceContext;
import org.apache.nifi.registry.extension.BundleVersionCoordinate;

public class StandardBundlePersistenceContext
implements BundlePersistenceContext {
    private final BundleVersionCoordinate coordinate;
    private final String author;
    private final long timestamp;
    private final long bundleSize;

    private StandardBundlePersistenceContext(Builder builder) {
        this.coordinate = Objects.requireNonNull(builder.coordinate);
        this.bundleSize = builder.bundleSize;
        this.author = builder.author;
        this.timestamp = builder.timestamp;
        Validate.notBlank((CharSequence)this.author);
    }

    public BundleVersionCoordinate getCoordinate() {
        return this.coordinate;
    }

    public long getSize() {
        return this.bundleSize;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getAuthor() {
        return this.author;
    }

    public static class Builder {
        private BundleVersionCoordinate coordinate;
        private String author;
        private long timestamp;
        private long bundleSize;

        public Builder coordinate(BundleVersionCoordinate identifier) {
            this.coordinate = identifier;
            return this;
        }

        public Builder author(String author) {
            this.author = author;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder bundleSize(long size) {
            this.bundleSize = size;
            return this;
        }

        public StandardBundlePersistenceContext build() {
            return new StandardBundlePersistenceContext(this);
        }
    }
}

