/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.debug;

import java.io.PrintStream;
import jetbrains.exodus.debug.MiscKt;
import jetbrains.exodus.debug.StackTrace;
import jetbrains.exodus.debug.StackTraceMap;
import jetbrains.exodus.env.TransactionBase;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0004J\u0006\u0010\u0016\u001a\u00020\u000fJ\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u0004J\u0006\u0010\u001a\u001a\u00020\u000fR\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/exodus/debug/TxnProfiler;", "Lmu/KLogging;", "()V", "<set-?>", "", "gcMovedBytes", "getGcMovedBytes", "()J", "gcTransactions", "getGcTransactions", "readonlyTxns", "Ljetbrains/exodus/debug/StackTraceMap;", "txnCounts", "txnWrittenBytes", "addGcMovedBytes", "", "bytes", "addReadonlyTxn", "txn", "Ljetbrains/exodus/env/TransactionBase;", "addTxn", "writtenBytes", "dump", "ps", "Ljava/io/PrintStream;", "incGcTransaction", "reset", "xodus-environment"})
public final class TxnProfiler
extends KLogging {
    private long gcTransactions;
    private long gcMovedBytes;
    @NotNull
    private final StackTraceMap readonlyTxns = new StackTraceMap();
    @NotNull
    private final StackTraceMap txnCounts = new StackTraceMap();
    @NotNull
    private final StackTraceMap txnWrittenBytes = new StackTraceMap();

    public final long getGcTransactions() {
        return this.gcTransactions;
    }

    public final long getGcMovedBytes() {
        return this.gcMovedBytes;
    }

    public final long incGcTransaction() {
        ++this.gcTransactions;
        return this.gcTransactions;
    }

    public final void addGcMovedBytes(long bytes) {
        this.gcMovedBytes += bytes;
    }

    public final void addReadonlyTxn(@NotNull TransactionBase txn) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        StackTrace stackTrace = txn.getTrace();
        if (stackTrace == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        StackTraceMap.add$default(this.readonlyTxns, stackTrace, 0L, 2, null);
    }

    public final void addTxn(@NotNull TransactionBase txn, long writtenBytes) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        StackTrace stackTrace = txn.getTrace();
        if (stackTrace == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        StackTrace trace = stackTrace;
        boolean bl = false;
        StackTraceMap.add$default(this.txnCounts, trace, 0L, 2, null);
        this.txnWrittenBytes.add(trace, writtenBytes);
    }

    public final void reset() {
        this.gcTransactions = 0L;
        this.gcMovedBytes = 0L;
        this.readonlyTxns.clear();
        this.txnCounts.clear();
        this.txnWrittenBytes.clear();
    }

    public final void dump() {
        this.getLogger().info((Function0)new Function0<Object>(this){
            final /* synthetic */ TxnProfiler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return MiscKt.dumpToString((Function1<? super PrintStream, Unit>)((Function1)new Function1<PrintStream, Unit>(this.this$0){
                    final /* synthetic */ TxnProfiler this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull PrintStream ps) {
                        Intrinsics.checkNotNullParameter((Object)ps, (String)"ps");
                        TxnProfiler.access$dump(this.this$0, ps);
                    }
                }));
            }
        });
    }

    private final void dump(PrintStream ps) {
        ps.println(Intrinsics.stringPlus((String)"GC transaction: ", (Object)this.gcTransactions));
        ps.println(Intrinsics.stringPlus((String)"Bytes moved by GC: ", (Object)this.gcMovedBytes));
        ps.println("Read-only transactions:");
        this.readonlyTxns.forEach((Function2<? super StackTrace, ? super Long, Unit>)((Function2)new Function2<StackTrace, Long, Unit>(ps){
            final /* synthetic */ PrintStream $ps;
            {
                this.$ps = $ps;
                super(2);
            }

            public final void invoke(@NotNull StackTrace st, long count) {
                Intrinsics.checkNotNullParameter((Object)st, (String)"st");
                this.$ps.println(count);
                st.toString(this.$ps);
            }
        }));
        ps.println("Transaction counts:");
        this.txnCounts.forEach((Function2<? super StackTrace, ? super Long, Unit>)((Function2)new Function2<StackTrace, Long, Unit>(ps){
            final /* synthetic */ PrintStream $ps;
            {
                this.$ps = $ps;
                super(2);
            }

            public final void invoke(@NotNull StackTrace st, long count) {
                Intrinsics.checkNotNullParameter((Object)st, (String)"st");
                this.$ps.println(count);
                st.toString(this.$ps);
            }
        }));
        ps.println("Transaction traffic (written bytes):");
        this.txnWrittenBytes.forEach((Function2<? super StackTrace, ? super Long, Unit>)((Function2)new Function2<StackTrace, Long, Unit>(ps){
            final /* synthetic */ PrintStream $ps;
            {
                this.$ps = $ps;
                super(2);
            }

            public final void invoke(@NotNull StackTrace st, long bytes) {
                Intrinsics.checkNotNullParameter((Object)st, (String)"st");
                this.$ps.print(bytes);
                this.$ps.println(" bytes");
                st.toString(this.$ps);
            }
        }));
    }

    public static final /* synthetic */ void access$dump(TxnProfiler $this, PrintStream ps) {
        $this.dump(ps);
    }
}

