/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto.diagnostics;

import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlType;
import org.apache.nifi.web.api.dto.diagnostics.GarbageCollectionDiagnosticsDTO;
import org.apache.nifi.web.api.dto.diagnostics.RepositoryUsageDTO;

@XmlType(name="jvmSystemDiagnosticsSnapshot")
public class JVMSystemDiagnosticsSnapshotDTO
implements Cloneable {
    private RepositoryUsageDTO flowFileRepositoryStorageUsage;
    private Set<RepositoryUsageDTO> contentRepositoryStorageUsage;
    private Set<RepositoryUsageDTO> provenanceRepositoryStorageUsage;
    private Long maxHeapBytes;
    private String maxHeap;
    private List<GarbageCollectionDiagnosticsDTO> garbageCollectionDiagnostics;
    private Integer cpuCores;
    private Double cpuLoadAverage;
    private Long physicalMemoryBytes;
    private String physicalMemory;
    private Long openFileDescriptors;
    private Long maxOpenFileDescriptors;

    @ApiModelProperty(value="Information about the FlowFile Repository's usage")
    public RepositoryUsageDTO getFlowFileRepositoryStorageUsage() {
        return this.flowFileRepositoryStorageUsage;
    }

    public void setFlowFileRepositoryStorageUsage(RepositoryUsageDTO flowFileRepositoryStorageUsage) {
        this.flowFileRepositoryStorageUsage = flowFileRepositoryStorageUsage;
    }

    @ApiModelProperty(value="Information about the Content Repository's usage")
    public Set<RepositoryUsageDTO> getContentRepositoryStorageUsage() {
        return this.contentRepositoryStorageUsage;
    }

    public void setContentRepositoryStorageUsage(Set<RepositoryUsageDTO> contentRepositoryStorageUsage) {
        this.contentRepositoryStorageUsage = contentRepositoryStorageUsage;
    }

    @ApiModelProperty(value="Information about the Provenance Repository's usage")
    public Set<RepositoryUsageDTO> getProvenanceRepositoryStorageUsage() {
        return this.provenanceRepositoryStorageUsage;
    }

    public void setProvenanceRepositoryStorageUsage(Set<RepositoryUsageDTO> provenanceRepositoryStorageUsage) {
        this.provenanceRepositoryStorageUsage = provenanceRepositoryStorageUsage;
    }

    @ApiModelProperty(value="The maximum number of bytes that the JVM heap is configured to use for heap")
    public Long getMaxHeapBytes() {
        return this.maxHeapBytes;
    }

    public void setMaxHeapBytes(Long heapBytes) {
        this.maxHeapBytes = heapBytes;
    }

    @ApiModelProperty(value="The maximum number of bytes that the JVM heap is configured to use, as a human-readable value")
    public String getMaxHeap() {
        return this.maxHeap;
    }

    public void setMaxHeap(String maxHeap) {
        this.maxHeap = maxHeap;
    }

    @ApiModelProperty(value="The number of CPU Cores available on the system")
    public Integer getCpuCores() {
        return this.cpuCores;
    }

    public void setCpuCores(Integer cpuCores) {
        this.cpuCores = cpuCores;
    }

    @ApiModelProperty(value="The 1-minute CPU Load Average")
    public Double getCpuLoadAverage() {
        return this.cpuLoadAverage;
    }

    public void setCpuLoadAverage(Double cpuLoadAverage) {
        this.cpuLoadAverage = cpuLoadAverage;
    }

    @ApiModelProperty(value="The number of bytes of RAM available on the system")
    public Long getPhysicalMemoryBytes() {
        return this.physicalMemoryBytes;
    }

    public void setPhysicalMemoryBytes(Long memoryBytes) {
        this.physicalMemoryBytes = memoryBytes;
    }

    @ApiModelProperty(value="The number of bytes of RAM available on the system as a human-readable value")
    public String getPhysicalMemory() {
        return this.physicalMemory;
    }

    public void setPhysicalMemory(String memory) {
        this.physicalMemory = memory;
    }

    @ApiModelProperty(value="The number of files that are open by the NiFi process")
    public Long getOpenFileDescriptors() {
        return this.openFileDescriptors;
    }

    public void setOpenFileDescriptors(Long openFileDescriptors) {
        this.openFileDescriptors = openFileDescriptors;
    }

    @ApiModelProperty(value="The maximum number of open file descriptors that are available to each process")
    public Long getMaxOpenFileDescriptors() {
        return this.maxOpenFileDescriptors;
    }

    public void setMaxOpenFileDescriptors(Long maxOpenFileDescriptors) {
        this.maxOpenFileDescriptors = maxOpenFileDescriptors;
    }

    @ApiModelProperty(value="Diagnostic information about the JVM's garbage collections")
    public List<GarbageCollectionDiagnosticsDTO> getGarbageCollectionDiagnostics() {
        return this.garbageCollectionDiagnostics;
    }

    public void setGarbageCollectionDiagnostics(List<GarbageCollectionDiagnosticsDTO> garbageCollectionDiagnostics) {
        this.garbageCollectionDiagnostics = garbageCollectionDiagnostics;
    }

    public JVMSystemDiagnosticsSnapshotDTO clone() {
        JVMSystemDiagnosticsSnapshotDTO clone = new JVMSystemDiagnosticsSnapshotDTO();
        clone.contentRepositoryStorageUsage = JVMSystemDiagnosticsSnapshotDTO.cloneRepoUsage(this.contentRepositoryStorageUsage);
        clone.cpuCores = this.cpuCores;
        clone.cpuLoadAverage = this.cpuLoadAverage;
        clone.flowFileRepositoryStorageUsage = this.flowFileRepositoryStorageUsage == null ? null : this.flowFileRepositoryStorageUsage.clone();
        clone.maxHeap = this.maxHeap;
        clone.maxHeapBytes = this.maxHeapBytes;
        clone.maxOpenFileDescriptors = this.maxOpenFileDescriptors;
        clone.openFileDescriptors = this.openFileDescriptors;
        clone.physicalMemory = this.physicalMemory;
        clone.physicalMemoryBytes = this.physicalMemoryBytes;
        clone.provenanceRepositoryStorageUsage = JVMSystemDiagnosticsSnapshotDTO.cloneRepoUsage(this.provenanceRepositoryStorageUsage);
        if (this.garbageCollectionDiagnostics != null) {
            clone.garbageCollectionDiagnostics = this.garbageCollectionDiagnostics.stream().map(gcDiag -> gcDiag.clone()).collect(Collectors.toList());
        }
        return clone;
    }

    private static Set<RepositoryUsageDTO> cloneRepoUsage(Set<RepositoryUsageDTO> repoUsage) {
        if (repoUsage == null) {
            return null;
        }
        return repoUsage.stream().map(usage -> usage.clone()).collect(Collectors.toSet());
    }
}

