/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.swap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.repository.SwapSummary;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.controller.repository.schema.ResourceClaimFieldMap;
import org.apache.nifi.controller.swap.StandardSwapSummary;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.repository.schema.RecordField;
import org.apache.nifi.repository.schema.RecordSchema;

public class SwapSummaryFieldMap
implements Record {
    private final SwapSummary swapSummary;
    private final RecordSchema schema;
    private final String queueIdentifier;
    private final Map<ResourceClaimFieldMap, Integer> claimCounts;

    public SwapSummaryFieldMap(SwapSummary summary, String queueIdentifier, RecordSchema schema) {
        this.swapSummary = summary;
        this.queueIdentifier = queueIdentifier;
        this.schema = schema;
        RecordField resourceClaimField = (RecordField)schema.getField("Resource Claims").getSubFields().get(0);
        RecordSchema resourceClaimSchema = new RecordSchema(resourceClaimField.getSubFields());
        List resourceClaims = summary.getResourceClaims();
        this.claimCounts = new HashMap<ResourceClaimFieldMap, Integer>();
        for (ResourceClaim claim : resourceClaims) {
            ResourceClaimFieldMap fieldMap = new ResourceClaimFieldMap(claim, resourceClaimSchema);
            Integer count = this.claimCounts.get(fieldMap);
            if (count == null) {
                this.claimCounts.put(fieldMap, 1);
                continue;
            }
            this.claimCounts.put(fieldMap, count + 1);
        }
    }

    public RecordSchema getSchema() {
        return this.schema;
    }

    public Object getFieldValue(String fieldName) {
        switch (fieldName) {
            case "Max Record ID": {
                return this.swapSummary.getMaxFlowFileId();
            }
            case "FlowFile Count": {
                return this.swapSummary.getQueueSize().getObjectCount();
            }
            case "FlowFile Size": {
                return this.swapSummary.getQueueSize().getByteCount();
            }
            case "Queue Identifier": {
                return this.queueIdentifier;
            }
            case "Resource Claims": {
                return this.claimCounts;
            }
            case "Min Last Queue Date": {
                return this.swapSummary.getMinLastQueueDate();
            }
            case "Total Last Queue Date": {
                return this.swapSummary.getTotalLastQueueDate();
            }
        }
        return null;
    }

    public static SwapSummary getSwapSummary(Record record, ResourceClaimManager claimManager) {
        Long totalLastQueueDate;
        int flowFileCount = (Integer)record.getFieldValue("FlowFile Count");
        long flowFileSize = (Long)record.getFieldValue("FlowFile Size");
        Long minLastQueueDate = (Long)record.getFieldValue("Min Last Queue Date");
        long now = System.currentTimeMillis();
        if (minLastQueueDate == null) {
            minLastQueueDate = now;
        }
        if ((totalLastQueueDate = (Long)record.getFieldValue("Total Last Queue Date")) == null) {
            totalLastQueueDate = now * (long)flowFileCount;
        }
        QueueSize queueSize = new QueueSize(flowFileCount, flowFileSize);
        long maxFlowFileId = (Long)record.getFieldValue("Max Record ID");
        Map resourceClaimRecords = (Map)record.getFieldValue("Resource Claims");
        ArrayList<ResourceClaim> resourceClaims = new ArrayList<ResourceClaim>();
        for (Map.Entry entry : resourceClaimRecords.entrySet()) {
            Record resourceClaimRecord = (Record)entry.getKey();
            ResourceClaim claim = ResourceClaimFieldMap.getResourceClaim((Record)resourceClaimRecord, (ResourceClaimManager)claimManager);
            for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                resourceClaims.add(claim);
            }
        }
        return new StandardSwapSummary(queueSize, maxFlowFileId, resourceClaims, minLastQueueDate, totalLastQueueDate);
    }
}

