/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import org.apache.nifi.controller.status.history.JsonNodeStatusHistoryDump;
import org.apache.nifi.controller.status.history.StatusHistory;
import org.apache.nifi.controller.status.history.StatusHistoryDump;
import org.apache.nifi.controller.status.history.StatusHistoryDumpFactory;
import org.apache.nifi.controller.status.history.StatusHistoryRepository;

public class JsonNodeStatusHistoryDumpFactory
implements StatusHistoryDumpFactory {
    private StatusHistoryRepository statusHistoryRepository;

    public StatusHistoryDump create(int days) {
        if (days <= 0) {
            throw new IllegalArgumentException(String.format("The number of days shall be greater than 0. The current value is %s.", days));
        }
        LocalDateTime endOfToday = LocalDateTime.now().with(LocalTime.MAX);
        LocalDateTime startOfDaysBefore = endOfToday.minusDays(days).with(LocalTime.MIN);
        Date endOfTodayDate = Date.from(endOfToday.atZone(ZoneId.systemDefault()).toInstant());
        Date startOfDaysBeforeDate = Date.from(startOfDaysBefore.atZone(ZoneId.systemDefault()).toInstant());
        StatusHistory nodeStatusHistory = this.statusHistoryRepository.getNodeStatusHistory(startOfDaysBeforeDate, endOfTodayDate);
        return new JsonNodeStatusHistoryDump(nodeStatusHistory);
    }

    public void setStatusHistoryRepository(StatusHistoryRepository statusHistoryRepository) {
        this.statusHistoryRepository = statusHistoryRepository;
    }
}

