/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue;

import org.apache.nifi.controller.queue.FlowFileQueueSize;
import org.apache.nifi.controller.queue.LocalQueuePartitionDiagnostics;
import org.apache.nifi.controller.queue.QueueSize;

public class StandardLocalQueuePartitionDiagnostics
implements LocalQueuePartitionDiagnostics {
    private final FlowFileQueueSize queueSize;
    private final boolean anyPenalized;
    private final boolean allPenalized;

    public StandardLocalQueuePartitionDiagnostics(FlowFileQueueSize queueSize, boolean anyPenalized, boolean allPenalized) {
        this.queueSize = queueSize;
        this.anyPenalized = anyPenalized;
        this.allPenalized = allPenalized;
    }

    public QueueSize getUnacknowledgedQueueSize() {
        return new QueueSize(this.queueSize.getUnacknowledgedCount(), (long)this.queueSize.getUnacknowledgedCount());
    }

    public QueueSize getActiveQueueSize() {
        return new QueueSize(this.queueSize.getActiveCount(), this.queueSize.getActiveBytes());
    }

    public QueueSize getSwapQueueSize() {
        return new QueueSize(this.queueSize.getSwappedCount(), this.queueSize.getSwappedBytes());
    }

    public int getSwapFileCount() {
        return this.queueSize.getSwapFileCount();
    }

    public boolean isAnyActiveFlowFilePenalized() {
        return this.anyPenalized;
    }

    public boolean isAllActiveFlowFilesPenalized() {
        return this.allPenalized;
    }
}

