/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.logout;

import java.util.Objects;
import org.apache.commons.lang3.Validate;

public class LogoutRequest {
    private final String requestIdentifier;
    private final String mappedUserIdentity;

    public LogoutRequest(String requestIdentifier, String mappedUserIdentity) {
        this.requestIdentifier = (String)Validate.notBlank((CharSequence)requestIdentifier, (String)"Request identifier is required", (Object[])new Object[0]);
        this.mappedUserIdentity = (String)Validate.notBlank((CharSequence)mappedUserIdentity, (String)"User identity is required", (Object[])new Object[0]);
    }

    public String getRequestIdentifier() {
        return this.requestIdentifier;
    }

    public String getMappedUserIdentity() {
        return this.mappedUserIdentity;
    }

    public int hashCode() {
        return Objects.hash(this.requestIdentifier, this.mappedUserIdentity);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogoutRequest)) {
            return false;
        }
        LogoutRequest other = (LogoutRequest)obj;
        return Objects.equals(this.requestIdentifier, other.requestIdentifier) && Objects.equals(this.mappedUserIdentity, other.mappedUserIdentity);
    }
}

