/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.properties;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.toolkit.tls.TlsToolkitMain;
import org.apache.nifi.toolkit.tls.properties.NiFiPropertiesWriter;

public class NiFiPropertiesWriterFactory {
    private final List<String> lines;

    public NiFiPropertiesWriterFactory() throws IOException {
        this(TlsToolkitMain.class.getClassLoader().getResourceAsStream("conf/nifi.properties"));
    }

    public NiFiPropertiesWriterFactory(InputStream inputStream) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                lines.add(line.trim());
            }
        }
        this.lines = Collections.unmodifiableList(lines);
    }

    public NiFiPropertiesWriter create() {
        return new NiFiPropertiesWriter(this.lines);
    }
}

