/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.manager;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.toolkit.tls.configuration.TlsClientConfig;
import org.apache.nifi.toolkit.tls.manager.BaseTlsManager;
import org.apache.nifi.toolkit.tls.manager.writer.ConfigurationWriter;
import org.apache.nifi.toolkit.tls.util.InputStreamFactory;
import org.apache.nifi.toolkit.tls.util.OutputStreamFactory;
import org.apache.nifi.toolkit.tls.util.PasswordUtil;
import org.apache.nifi.toolkit.tls.util.TlsHelper;
import org.apache.nifi.util.StringUtils;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class TlsClientManager
extends BaseTlsManager {
    private final TlsClientConfig tlsClientConfig;
    private final KeyStore trustStore;
    private final List<ConfigurationWriter<TlsClientConfig>> configurationWriters;
    private final Set<String> certificateAliases;
    private File certificateAuthorityDirectory;

    public TlsClientManager(TlsClientConfig tlsClientConfig) throws GeneralSecurityException, IOException {
        this(tlsClientConfig, new PasswordUtil(), FileInputStream::new);
    }

    public TlsClientManager(TlsClientConfig tlsClientConfig, PasswordUtil passwordUtil, InputStreamFactory inputStreamFactory) throws GeneralSecurityException, IOException {
        super(tlsClientConfig, passwordUtil, inputStreamFactory);
        this.trustStore = this.loadKeystore(tlsClientConfig.getTrustStore(), tlsClientConfig.getTrustStoreType(), tlsClientConfig.getTrustStorePassword());
        this.tlsClientConfig = tlsClientConfig;
        this.configurationWriters = new ArrayList<ConfigurationWriter<TlsClientConfig>>();
        this.certificateAliases = new HashSet<String>();
    }

    public void setCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        this.trustStore.setCertificateEntry(alias, cert);
        this.certificateAliases.add(alias);
    }

    public void setCertificateAuthorityDirectory(File certificateAuthorityDirectory) {
        this.certificateAuthorityDirectory = certificateAuthorityDirectory;
    }

    @Override
    public void write(OutputStreamFactory outputStreamFactory) throws IOException, GeneralSecurityException {
        super.write(outputStreamFactory);
        String trustStorePassword = this.tlsClientConfig.getTrustStorePassword();
        boolean trustStorePasswordGenerated = false;
        if (StringUtils.isEmpty((String)trustStorePassword)) {
            trustStorePassword = this.getPasswordUtil().generatePassword();
            trustStorePasswordGenerated = true;
        }
        trustStorePassword = TlsHelper.writeKeyStore(this.trustStore, outputStreamFactory, new File(this.tlsClientConfig.getTrustStore()), trustStorePassword, trustStorePasswordGenerated);
        this.tlsClientConfig.setTrustStorePassword(trustStorePassword);
        for (ConfigurationWriter<TlsClientConfig> configurationWriter : this.configurationWriters) {
            configurationWriter.write(this.tlsClientConfig, outputStreamFactory);
        }
        if (this.certificateAuthorityDirectory != null) {
            for (String alias : Collections.list(this.trustStore.aliases())) {
                try {
                    KeyStore.Entry trustStoreEntry = this.trustStore.getEntry(alias, null);
                    if (!(trustStoreEntry instanceof KeyStore.TrustedCertificateEntry)) continue;
                    Certificate trustedCertificate = ((KeyStore.TrustedCertificateEntry)trustStoreEntry).getTrustedCertificate();
                    OutputStream outputStream = outputStreamFactory.create(new File(this.certificateAuthorityDirectory, TlsHelper.escapeFilename(alias) + ".pem"));
                    Throwable throwable = null;
                    try {
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
                        Throwable throwable2 = null;
                        try {
                            PemWriter pemWriter = new PemWriter((Writer)outputStreamWriter);
                            Throwable throwable3 = null;
                            try {
                                pemWriter.writeObject((PemObjectGenerator)new JcaMiscPEMGenerator((Object)trustedCertificate));
                            }
                            catch (Throwable throwable4) {
                                throwable3 = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (pemWriter == null) continue;
                                if (throwable3 != null) {
                                    try {
                                        pemWriter.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable3.addSuppressed(throwable5);
                                    }
                                    continue;
                                }
                                pemWriter.close();
                            }
                        }
                        catch (Throwable throwable6) {
                            throwable2 = throwable6;
                            throw throwable6;
                        }
                        finally {
                            if (outputStreamWriter == null) continue;
                            if (throwable2 != null) {
                                try {
                                    outputStreamWriter.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable2.addSuppressed(throwable7);
                                }
                                continue;
                            }
                            outputStreamWriter.close();
                        }
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (outputStream == null) continue;
                        if (throwable != null) {
                            try {
                                outputStream.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                            continue;
                        }
                        outputStream.close();
                    }
                }
                catch (UnrecoverableEntryException unrecoverableEntryException) {}
            }
        }
    }

    public void addClientConfigurationWriter(ConfigurationWriter<TlsClientConfig> configurationWriter) {
        this.configurationWriters.add(configurationWriter);
    }
}

