/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Chars;
import io.questdb.std.IntHashSet;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Files {
    public static final int DT_DIR = 4;
    public static final int DT_FILE = 8;
    public static final int DT_LNK = 10;
    public static final int DT_UNKNOWN = 0;
    public static final int FILES_RENAME_ERR_EXDEV = 1;
    public static final int FILES_RENAME_ERR_OTHER = 2;
    public static final int FILES_RENAME_OK = 0;
    public static final int MAP_RO = 1;
    public static final int MAP_RW = 2;
    public static final long PAGE_SIZE;
    public static final int POSIX_FADV_RANDOM;
    public static final int POSIX_FADV_SEQUENTIAL;
    public static final int POSIX_MADV_RANDOM;
    public static final int POSIX_MADV_SEQUENTIAL;
    public static final char SEPARATOR;
    public static final Charset UTF_8;
    public static final int WINDOWS_ERROR_FILE_EXISTS = 80;
    private static final AtomicInteger OPEN_FILE_COUNT;
    static IntHashSet openFds;

    private Files() {
    }

    public static native boolean allocate(int var0, long var1);

    public static native long append(int var0, long var1, long var3);

    public static synchronized boolean auditClose(int fd) {
        if (fd < 0) {
            throw new IllegalStateException("Invalid fd " + fd);
        }
        if (openFds.remove(fd) == -1) {
            throw new IllegalStateException("fd " + fd + " is already closed!");
        }
        return true;
    }

    public static synchronized boolean auditOpen(int fd) {
        if (openFds == null) {
            openFds = new IntHashSet();
        }
        if (fd < 0) {
            throw new IllegalStateException("Invalid fd " + fd);
        }
        if (openFds.contains(fd)) {
            throw new IllegalStateException("fd " + fd + " is already open");
        }
        openFds.add(fd);
        return true;
    }

    public static int bumpFileCount(int fd) {
        if (fd != -1) {
            assert (Files.auditOpen(fd));
            OPEN_FILE_COUNT.incrementAndGet();
        }
        return fd;
    }

    public static long ceilPageSize(long size) {
        return (size + PAGE_SIZE - 1L) / PAGE_SIZE * PAGE_SIZE;
    }

    public static int close(int fd) {
        if (fd > 1) {
            assert (Files.auditClose(fd));
            int res = Files.close0(fd);
            if (res == 0) {
                OPEN_FILE_COUNT.decrementAndGet();
            }
            return res;
        }
        return -1;
    }

    public static native int copy(long var0, long var2);

    public static int copy(LPSZ from, LPSZ to) {
        return Files.copy(from.address(), to.address());
    }

    public static native long copyData(int var0, int var1, long var2, long var4);

    public static void decrementFileCount(int fd) {
        assert (Files.auditClose(fd));
        OPEN_FILE_COUNT.decrementAndGet();
    }

    public static native boolean exists(int var0);

    public static boolean exists(LPSZ lpsz) {
        return lpsz != null && Files.exists0(lpsz.address());
    }

    public static void fadvise(int fd, long offset, long len, int advise) {
        if (Os.type == 2 || Os.type == 4) {
            Files.fadvise0(fd, offset, len, advise);
        }
    }

    public static native void fadvise0(int var0, long var1, long var3, int var5);

    public static native void findClose(long var0);

    public static long findFirst(LPSZ lpsz) {
        return Files.findFirst(lpsz.address());
    }

    public static native long findName(long var0);

    public static native int findNext(long var0);

    public static native int findType(long var0);

    public static long floorPageSize(long size) {
        return size - size % PAGE_SIZE;
    }

    public static native int fsync(int var0);

    public static long getDiskSize(LPSZ path) {
        if (path != null) {
            return Files.getDiskSize(path.address());
        }
        return Files.getDiskSize(0L);
    }

    public static int getFileSystemStatus(LPSZ lpszName) {
        assert (lpszName.capacity() > 127);
        return Files.getFileSystemStatus(lpszName.address());
    }

    public static long getLastModified(LPSZ lpsz) {
        return Files.getLastModified(lpsz.address());
    }

    public static String getOpenFdDebugInfo() {
        if (openFds != null) {
            return openFds.toString();
        }
        return null;
    }

    public static long getOpenFileCount() {
        return OPEN_FILE_COUNT.get();
    }

    public static native int getStdOutFd();

    public static native int hardLink(long var0, long var2);

    public static int hardLink(LPSZ src, LPSZ hardLink) {
        return Files.hardLink(src.address(), hardLink.address());
    }

    public static boolean isDirOrSoftLinkDirNoDots(Path path, int rootLen, long pUtf8NameZ, int type) {
        return 0 != Files.typeDirOrSoftLinkDirNoDots(path, rootLen, pUtf8NameZ, type, null);
    }

    public static boolean isDirOrSoftLinkDirNoDots(Path path, int rootLen, long pUtf8NameZ, int type, @NotNull StringSink nameSink) {
        return 0 != Files.typeDirOrSoftLinkDirNoDots(path, rootLen, pUtf8NameZ, type, nameSink);
    }

    public static boolean isDots(CharSequence name) {
        return Chars.equals(name, '.') || Chars.equals(name, (CharSequence)"..");
    }

    public static native boolean isSoftLink(long var0);

    public static boolean isSoftLink(LPSZ path) {
        return Files.isSoftLink(path.address());
    }

    public static long length(LPSZ lpsz) {
        return Files.length0(lpsz.address());
    }

    public static native long length(int var0);

    public static native int lock(int var0);

    public static void madvise(long address, long len, int advise) {
        if (Os.type == 2 || Os.type == 4) {
            Files.madvise0(address, len, advise);
        }
    }

    public static native void madvise0(long var0, long var2, int var4);

    public static int mkdir(Path path, int mode) {
        return Files.mkdir(path.address(), mode);
    }

    public static int mkdirs(Path path, int mode) {
        int n = path.length();
        for (int i = 0; i < n; ++i) {
            int r;
            char c = path.charAt(i);
            if (c != SEPARATOR || i == 0 && Os.isPosix() || i == 2 && Os.isWindows() && path.charAt(1) == ':') continue;
            path.$at(i);
            if (path.length() > 0 && !Files.exists(path) && (r = Files.mkdir(path, mode)) != 0) {
                path.put(i, SEPARATOR);
                return r;
            }
            path.put(i, SEPARATOR);
        }
        return 0;
    }

    public static long mmap(int fd, long len, long offset, int flags, int memoryTag) {
        long address = Files.mmap0(fd, len, offset, flags, 0L);
        if (address != -1L) {
            Unsafe.recordMemAlloc(len, memoryTag);
        }
        return address;
    }

    public static long mremap(int fd, long address, long previousSize, long newSize, long offset, int flags, int memoryTag) {
        Unsafe.recordMemAlloc(-previousSize, memoryTag);
        address = Files.mremap0(fd, address, previousSize, newSize, offset, flags);
        if (address != -1L) {
            Unsafe.recordMemAlloc(newSize, memoryTag);
        }
        return address;
    }

    public static native int msync(long var0, long var2, boolean var4);

    public static void munmap(long address, long len, int memoryTag) {
        if (address != 0L && Files.munmap0(address, len) != -1) {
            Unsafe.recordMemAlloc(-len, memoryTag);
        }
    }

    public static native long noop();

    public static boolean notDots(CharSequence value) {
        int len = value.length();
        if (len > 2) {
            return true;
        }
        if (value.charAt(0) != '.') {
            return true;
        }
        return len == 2 && value.charAt(1) != '.';
    }

    public static boolean notDots(long pUtf8NameZ) {
        byte b0 = Unsafe.getUnsafe().getByte(pUtf8NameZ);
        if (b0 != 46) {
            return true;
        }
        byte b1 = Unsafe.getUnsafe().getByte(pUtf8NameZ + 1L);
        return b1 != 0 && (b1 != 46 || Unsafe.getUnsafe().getByte(pUtf8NameZ + 2L) != 0);
    }

    public static int openAppend(LPSZ lpsz) {
        return Files.bumpFileCount(Files.openAppend(lpsz.address()));
    }

    public static int openCleanRW(LPSZ lpsz, long size) {
        return Files.bumpFileCount(Files.openCleanRW(lpsz.address(), size));
    }

    public static native int openCleanRW(long var0, long var2);

    public static int openRO(LPSZ lpsz) {
        return Files.bumpFileCount(Files.openRO(lpsz.address()));
    }

    public static int openRW(LPSZ lpsz) {
        return Files.bumpFileCount(Files.openRW(lpsz.address()));
    }

    public static int openRW(LPSZ lpsz, long opts) {
        return Files.bumpFileCount(Files.openRWOpts(lpsz.address(), opts));
    }

    public static native long read(int var0, long var1, long var3, long var5);

    public static native byte readNonNegativeByte(int var0, long var1);

    public static native int readNonNegativeInt(int var0, long var1);

    public static native long readNonNegativeLong(int var0, long var1);

    public static native short readNonNegativeShort(int var0, long var1);

    public static boolean remove(LPSZ lpsz) {
        return Files.remove(lpsz.address());
    }

    public static int rename(LPSZ oldName, LPSZ newName) {
        return Files.rename(oldName.address(), newName.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int rmdir(Path path) {
        long p = Files.findFirst(path.address());
        int len = path.length();
        int errno = -1;
        if (p > 0L) {
            try {
                do {
                    long lpszName = Files.findName(p);
                    path.trimTo(len).concat(lpszName).$();
                    if (Files.findType(p) == 4) {
                        if (Files.strcmp(lpszName, "..") || Files.strcmp(lpszName, ".") || (errno = Files.rmdir(path)) == 0) {
                            continue;
                        }
                    } else {
                        if (Files.remove(path.address())) continue;
                        errno = Os.errno();
                    }
                    int n = errno;
                    return n;
                } while (Files.findNext(p) > 0);
            }
            finally {
                Files.findClose(p);
            }
            if (Files.rmdir(path.trimTo(len).$().address())) {
                return 0;
            }
            return Os.errno();
        }
        return errno;
    }

    public static boolean setLastModified(LPSZ lpsz, long millis) {
        return Files.setLastModified(lpsz.address(), millis);
    }

    public static native int softLink(long var0, long var2);

    public static int softLink(LPSZ src, LPSZ softLink) {
        return Files.softLink(src.address(), softLink.address());
    }

    public static native int sync();

    public static boolean touch(LPSZ lpsz) {
        boolean result;
        int fd = Files.openRW(lpsz);
        boolean bl = result = fd > 0;
        if (result) {
            Files.close(fd);
        }
        return result;
    }

    public static native boolean truncate(int var0, long var1);

    public static int typeDirOrSoftLinkDirNoDots(Path path, int rootLen, long pUtf8NameZ, int type, @Nullable StringSink nameSink) {
        if (!Files.notDots(pUtf8NameZ)) {
            return 0;
        }
        if (type == 4) {
            if (nameSink != null) {
                nameSink.clear();
                Chars.utf8DecodeZ(pUtf8NameZ, nameSink);
            }
            path.trimTo(rootLen).concat(pUtf8NameZ).$();
            return 4;
        }
        if (type == 10) {
            if (nameSink != null) {
                nameSink.clear();
                Chars.utf8DecodeZ(pUtf8NameZ, nameSink);
            }
            path.trimTo(rootLen).concat(pUtf8NameZ).$();
            if (Files.isDir(path.address())) {
                return 10;
            }
        }
        return 0;
    }

    public static native int unlink(long var0);

    public static int unlink(LPSZ softLink) {
        return Files.unlink(softLink.address());
    }

    public static native long write(int var0, long var1, long var3, long var5);

    private static native int close0(int var0);

    private static native boolean exists0(long var0);

    private static native long getDiskSize(long var0);

    private static native int getFileSystemStatus(long var0);

    private static native long getLastModified(long var0);

    private static native long getPageSize();

    private static native int getPosixFadvRandom();

    private static native int getPosixFadvSequential();

    private static native int getPosixMadvRandom();

    private static native int getPosixMadvSequential();

    private static native boolean isDir(long var0);

    private static native long length0(long var0);

    private static native int mkdir(long var0, int var2);

    private static native long mmap0(int var0, long var1, long var3, int var5, long var6);

    private static native long mremap0(int var0, long var1, long var3, long var5, long var7, int var9);

    private static native int munmap0(long var0, long var2);

    private static native int openAppend(long var0);

    private static native int openRO(long var0);

    private static native int openRW(long var0);

    private static native int openRWOpts(long var0, long var2);

    private static native boolean remove(long var0);

    private static native int rename(long var0, long var2);

    private static native boolean rmdir(long var0);

    private static native boolean setLastModified(long var0, long var2);

    static native long findFirst(long var0);

    static boolean strcmp(long lpsz, CharSequence s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            byte b = Unsafe.getUnsafe().getByte(lpsz + (long)i);
            if (b != 0 && b == (byte)s.charAt(i)) continue;
            return false;
        }
        return Unsafe.getUnsafe().getByte(lpsz + (long)len) == 0;
    }

    static {
        OPEN_FILE_COUNT = new AtomicInteger();
        Os.init();
        UTF_8 = StandardCharsets.UTF_8;
        PAGE_SIZE = Files.getPageSize();
        SEPARATOR = File.separatorChar;
        if (Os.type == 2 || Os.type == 4) {
            POSIX_FADV_RANDOM = Files.getPosixFadvRandom();
            POSIX_FADV_SEQUENTIAL = Files.getPosixFadvSequential();
            POSIX_MADV_RANDOM = Files.getPosixMadvRandom();
            POSIX_MADV_SEQUENTIAL = Files.getPosixMadvSequential();
        } else {
            POSIX_FADV_SEQUENTIAL = -1;
            POSIX_FADV_RANDOM = -1;
            POSIX_MADV_SEQUENTIAL = -1;
            POSIX_MADV_RANDOM = -1;
        }
    }
}

