/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.converter;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public final class ClaimTypeConverter
implements Converter<Map<String, Object>, Map<String, Object>> {
    private final Map<String, Converter<Object, ?>> claimTypeConverters;

    public ClaimTypeConverter(Map<String, Converter<Object, ?>> claimTypeConverters) {
        Assert.notEmpty(claimTypeConverters, (String)"claimTypeConverters cannot be empty");
        Assert.noNullElements((Object[])claimTypeConverters.values().toArray(), (String)"Converter(s) cannot be null");
        this.claimTypeConverters = Collections.unmodifiableMap(new LinkedHashMap(claimTypeConverters));
    }

    public Map<String, Object> convert(Map<String, Object> claims) {
        if (CollectionUtils.isEmpty(claims)) {
            return claims;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(claims);
        this.claimTypeConverters.forEach((claimName, typeConverter) -> {
            Object claim;
            Object mappedClaim;
            if (claims.containsKey(claimName) && (mappedClaim = typeConverter.convert(claim = claims.get(claimName))) != null) {
                result.put((String)claimName, mappedClaim);
            }
        });
        return result;
    }
}

