/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.tenant;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.registry.authorization.Tenant;

public final class TenantHelper {
    private TenantHelper() {
    }

    public static <T extends Tenant> Set<Tenant> selectExistingTenants(String names, String ids, List<T> allTenants) {
        String separator = ",";
        HashSet<String> nameSet = new HashSet<String>(Arrays.asList(Optional.ofNullable(names).orElse("").split(separator)));
        HashSet<String> idSet = new HashSet<String>(Arrays.asList(Optional.ofNullable(ids).orElse("").split(separator)));
        Set<Tenant> existingTentants = allTenants.stream().filter(tenant -> nameSet.contains(tenant.getIdentity()) || idSet.contains(tenant.getIdentifier())).collect(Collectors.toSet());
        return existingTentants;
    }
}

