/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.flow;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.client.FlowClient;
import org.apache.nifi.registry.client.FlowSnapshotClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.toolkit.cli.impl.util.JacksonUtils;

public class ImportFlowVersion
extends AbstractNiFiRegistryCommand<StringResult> {
    public ImportFlowVersion() {
        super("import-flow-version", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Imports a version of a flow from a local file, or a public URL. The imported version automatically becomes the next version of the given flow.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.FLOW_ID.createOption());
        this.addOption(CommandOption.INPUT_SOURCE.createOption());
    }

    @Override
    public StringResult doExecute(NiFiRegistryClient client, Properties properties) throws ParseException, IOException, NiFiRegistryException {
        Integer version;
        String flowId = this.getRequiredArg(properties, CommandOption.FLOW_ID);
        String inputFile = this.getRequiredArg(properties, CommandOption.INPUT_SOURCE);
        String contents = this.getInputSourceContent(inputFile);
        FlowClient flowClient = client.getFlowClient();
        FlowSnapshotClient snapshotClient = client.getFlowSnapshotClient();
        ObjectMapper objectMapper = JacksonUtils.getObjectMapper();
        VersionedFlowSnapshot deserializedSnapshot = (VersionedFlowSnapshot)objectMapper.readValue(contents, VersionedFlowSnapshot.class);
        if (deserializedSnapshot == null) {
            throw new IOException("Unable to deserialize flow version from " + inputFile);
        }
        VersionedFlow versionedFlow = flowClient.get(flowId);
        try {
            VersionedFlowSnapshotMetadata latestMetadata = snapshotClient.getLatestMetadata(flowId);
            version = latestMetadata.getVersion() + 1;
        }
        catch (NiFiRegistryException e) {
            version = 1;
        }
        VersionedFlowSnapshotMetadata metadata = new VersionedFlowSnapshotMetadata();
        metadata.setBucketIdentifier(versionedFlow.getBucketIdentifier());
        metadata.setFlowIdentifier(flowId);
        metadata.setVersion(version.intValue());
        VersionedFlowSnapshotMetadata deserializedSnapshotMetadata = deserializedSnapshot.getSnapshotMetadata();
        if (deserializedSnapshotMetadata != null) {
            metadata.setComments(deserializedSnapshotMetadata.getComments());
        }
        VersionedFlowSnapshot snapshot = new VersionedFlowSnapshot();
        snapshot.setSnapshotMetadata(metadata);
        snapshot.setFlowContents(deserializedSnapshot.getFlowContents());
        snapshot.setExternalControllerServices(deserializedSnapshot.getExternalControllerServices());
        snapshot.setParameterContexts(deserializedSnapshot.getParameterContexts());
        snapshot.setParameterProviders(deserializedSnapshot.getParameterProviders());
        snapshot.setFlowEncodingVersion(deserializedSnapshot.getFlowEncodingVersion());
        VersionedFlowSnapshot createdSnapshot = snapshotClient.create(snapshot);
        VersionedFlowSnapshotMetadata createdMetadata = createdSnapshot.getSnapshotMetadata();
        return new StringResult(String.valueOf(createdMetadata.getVersion()), this.getContext().isInteractive());
    }
}

