/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.templates;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.TemplatesClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.TemplateResult;
import org.apache.nifi.web.api.dto.TemplateDTO;

public class DownloadTemplate
extends AbstractNiFiCommand<TemplateResult> {
    public DownloadTemplate() {
        super("download-template", TemplateResult.class);
    }

    @Override
    public String getDescription() {
        return "Downloads the template file.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.TEMPLATE_ID.createOption());
        this.addOption(CommandOption.OUTPUT_FILE.createOption());
    }

    @Override
    public TemplateResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, CommandException, MissingOptionException {
        String templateId = this.getRequiredArg(properties, CommandOption.TEMPLATE_ID);
        TemplatesClient templatesClient = client.getTemplatesClient();
        TemplateDTO templateEntityResult = templatesClient.getTemplate(templateId);
        String outputFile = properties.containsKey(CommandOption.OUTPUT_FILE.getLongName()) ? properties.getProperty(CommandOption.OUTPUT_FILE.getLongName()) : null;
        return new TemplateResult(templateEntityResult, outputFile);
    }
}

