/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ProcessGroupClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.VariableRegistryResult;
import org.apache.nifi.web.api.entity.VariableRegistryEntity;

public class PGGetVars
extends AbstractNiFiCommand<VariableRegistryResult> {
    public PGGetVars() {
        super("pg-get-vars", VariableRegistryResult.class);
    }

    @Override
    public String getDescription() {
        return "Returns the variable registry for a given process group.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
    }

    @Override
    public VariableRegistryResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String pgId = this.getRequiredArg(properties, CommandOption.PG_ID);
        ProcessGroupClient pgClient = client.getProcessGroupClient();
        VariableRegistryEntity varEntity = pgClient.getVariables(pgId);
        return new VariableRegistryResult(this.getResultType(properties), varEntity);
    }
}

