/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi;

import com.opencsv.CSVParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.ClientFactory;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Result;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.AbstractPropertyCommand;
import org.apache.nifi.toolkit.cli.impl.session.SessionVariable;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.dto.TenantDTO;
import org.apache.nifi.web.api.entity.TenantEntity;
import org.apache.nifi.web.api.entity.UserEntity;
import org.apache.nifi.web.api.entity.UserGroupEntity;
import org.apache.nifi.web.api.entity.UserGroupsEntity;
import org.apache.nifi.web.api.entity.UsersEntity;

public abstract class AbstractNiFiCommand<R extends Result>
extends AbstractPropertyCommand<R> {
    public AbstractNiFiCommand(String name, Class<R> resultClass) {
        super(name, resultClass);
    }

    @Override
    protected SessionVariable getPropertiesSessionVariable() {
        return SessionVariable.NIFI_CLIENT_PROPS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final R doExecute(Properties properties) throws CommandException {
        ClientFactory<NiFiClient> clientFactory = this.getContext().getNiFiClientFactory();
        try (NiFiClient client = clientFactory.createClient(properties);){
            R r = this.doExecute(client, properties);
            return r;
        }
        catch (Exception e) {
            throw new CommandException("Error executing command '" + this.getName() + "' : " + e.getMessage(), e);
        }
    }

    public abstract R doExecute(NiFiClient var1, Properties var2) throws NiFiClientException, IOException, MissingOptionException, CommandException;

    protected RevisionDTO getInitialRevisionDTO() {
        String clientId = this.getContext().getSession().getNiFiClientID();
        RevisionDTO revisionDTO = new RevisionDTO();
        revisionDTO.setVersion(Long.valueOf(0L));
        revisionDTO.setClientId(clientId);
        return revisionDTO;
    }

    protected static Set<TenantEntity> generateTenantEntities(String ids) throws IOException {
        CSVParser csvParser = new CSVParser();
        return Arrays.stream(csvParser.parseLine(ids)).map(AbstractNiFiCommand::createTenantEntity).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected static Set<TenantEntity> generateTenantEntities(String users, UsersEntity existingUsers) throws IOException, CommandException {
        CSVParser csvParser = new CSVParser();
        String[] userArray = csvParser.parseLine(users);
        LinkedHashSet<TenantEntity> tenantEntities = new LinkedHashSet<TenantEntity>();
        for (String user : userArray) {
            Optional<UserEntity> existingUser = existingUsers.getUsers().stream().filter(entity -> user.equals(entity.getComponent().getIdentity())).findAny();
            if (!existingUser.isPresent()) {
                throw new CommandException("User with the identity '" + user + "' not found.");
            }
            tenantEntities.add(AbstractNiFiCommand.createTenantEntity(existingUser.get().getId(), user));
        }
        return tenantEntities;
    }

    protected static Set<TenantEntity> generateTenantEntities(String groups, UserGroupsEntity existingGroups) throws IOException, CommandException {
        CSVParser csvParser = new CSVParser();
        String[] groupArray = csvParser.parseLine(groups);
        LinkedHashSet<TenantEntity> tenantEntities = new LinkedHashSet<TenantEntity>();
        for (String group : groupArray) {
            Optional<UserGroupEntity> existingGroup = existingGroups.getUserGroups().stream().filter(entity -> group.equals(entity.getComponent().getIdentity())).findAny();
            if (!existingGroup.isPresent()) {
                throw new CommandException("User group with the identity '" + group + "' not found.");
            }
            tenantEntities.add(AbstractNiFiCommand.createTenantEntity(existingGroup.get().getId(), group));
        }
        return tenantEntities;
    }

    private static TenantEntity createTenantEntity(String id) {
        return AbstractNiFiCommand.createTenantEntity(id, null);
    }

    private static TenantEntity createTenantEntity(String id, String identity) {
        TenantEntity tenantEntity = new TenantEntity();
        tenantEntity.setId(id);
        if (StringUtils.isNotBlank((CharSequence)identity)) {
            TenantDTO tenantDTO = new TenantDTO();
            tenantDTO.setIdentity(identity);
            tenantEntity.setComponent(tenantDTO);
        }
        return tenantEntity;
    }
}

