/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl;

import java.io.IOException;
import javax.ws.rs.client.WebTarget;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.OutputPortClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.RequestConfig;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.CRUDJerseyClient;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.entity.PortEntity;

public class JerseyOutputPortClient
extends CRUDJerseyClient<PortEntity>
implements OutputPortClient {
    public JerseyOutputPortClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyOutputPortClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(baseTarget.path("/process-groups/{pgId}/output-ports"), baseTarget.path("/output-ports/{id}"), requestConfig, PortEntity.class, "Output Port");
    }

    @Override
    public PortEntity createOutputPort(String parentGroupId, PortEntity entity) throws NiFiClientException, IOException {
        return this.createComponent(parentGroupId, entity);
    }

    @Override
    public PortEntity getOutputPort(String id) throws NiFiClientException, IOException {
        return (PortEntity)this.getComponent(id);
    }

    @Override
    public PortEntity updateOutputPort(PortEntity entity) throws NiFiClientException, IOException {
        return this.updateComponent(entity);
    }

    @Override
    public PortEntity deleteOutputPort(PortEntity entity) throws NiFiClientException, IOException {
        return this.deleteComponent(entity);
    }

    @Override
    public PortEntity startInpuOutputPort(PortEntity entity) throws NiFiClientException, IOException {
        return this.startOutputPort(entity);
    }

    @Override
    public PortEntity startOutputPort(PortEntity entity) throws NiFiClientException, IOException {
        PortEntity startEntity = this.createStateEntity(entity, "RUNNING");
        return this.updateOutputPort(startEntity);
    }

    @Override
    public PortEntity stopOutputPort(PortEntity entity) throws NiFiClientException, IOException {
        PortEntity startEntity = this.createStateEntity(entity, "STOPPED");
        return this.updateOutputPort(startEntity);
    }

    private PortEntity createStateEntity(PortEntity entity, String state) {
        PortDTO component = new PortDTO();
        component.setId(entity.getComponent().getId());
        component.setParentGroupId(entity.getComponent().getParentGroupId());
        component.setState(state);
        PortEntity stateEntity = new PortEntity();
        stateEntity.setId(entity.getId());
        stateEntity.setRevision(entity.getRevision());
        stateEntity.setComponent(component);
        return stateEntity;
    }
}

