/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.util.Properties;
import org.apache.nifi.properties.EncodedSensitivePropertyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientBasedEncodedSensitivePropertyProvider<T>
extends EncodedSensitivePropertyProvider {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final T client;
    private final Properties properties;

    public ClientBasedEncodedSensitivePropertyProvider(T client, Properties properties) {
        this.client = client;
        this.properties = properties;
        this.validate(client);
    }

    public boolean isSupported() {
        return this.client != null;
    }

    public void cleanUp() {
        this.logger.debug("Cleanup Started");
    }

    protected Properties getProperties() {
        return this.properties;
    }

    protected T getClient() {
        if (this.client == null) {
            throw new IllegalStateException("Client not configured");
        }
        return this.client;
    }

    protected void validate(T configuredClient) {
        if (configuredClient == null) {
            this.logger.debug("Client not configured");
        }
    }
}

