/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.diff;

import java.util.Objects;
import org.apache.nifi.flow.ScheduledState;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedFlowCoordinates;
import org.apache.nifi.registry.flow.diff.DifferenceDescriptor;
import org.apache.nifi.registry.flow.diff.DifferenceType;
import org.apache.nifi.registry.flow.diff.FlowDifferenceUtil;

public class ConciseEvolvingDifferenceDescriptor
implements DifferenceDescriptor {
    @Override
    public String describeDifference(DifferenceType type, String flowAName, String flowBName, VersionedComponent componentA, VersionedComponent componentB, String fieldName, Object valueA, Object valueB) {
        String description;
        switch (type) {
            case COMPONENT_ADDED: {
                description = String.format("%s was added", componentB.getComponentType().getTypeName());
                break;
            }
            case COMPONENT_REMOVED: {
                description = String.format("%s was removed", componentA.getComponentType().getTypeName());
                break;
            }
            case SCHEDULED_STATE_CHANGED: {
                if (valueB == ScheduledState.RUNNING) {
                    description = String.format("%s was started", componentB.getComponentType().getTypeName());
                    break;
                }
                if (valueB == ScheduledState.ENABLED) {
                    description = String.format("%s was enabled", componentB.getComponentType().getTypeName());
                    break;
                }
                description = String.format("%s was disabled", componentA.getComponentType().getTypeName());
                break;
            }
            case PROPERTY_ADDED: {
                description = String.format("Property '%s' was added", fieldName);
                break;
            }
            case PROPERTY_REMOVED: {
                description = String.format("Property '%s' was removed", fieldName);
                break;
            }
            case PROPERTY_PARAMETERIZED: {
                description = String.format("Property '%s' was parameterized", fieldName);
                break;
            }
            case PROPERTY_PARAMETERIZATION_REMOVED: {
                description = String.format("Property '%s' is no longer a parameter reference", fieldName);
                break;
            }
            case VARIABLE_ADDED: {
                description = String.format("Variable '%s' was added", fieldName);
                break;
            }
            case VARIABLE_REMOVED: {
                description = String.format("Variable '%s' was removed", fieldName);
                break;
            }
            case POSITION_CHANGED: {
                description = "Position was changed";
                break;
            }
            case SIZE_CHANGED: {
                description = "Size was changed";
                break;
            }
            case BENDPOINTS_CHANGED: {
                description = "Connection Bendpoints changed";
                break;
            }
            case VERSIONED_FLOW_COORDINATES_CHANGED: {
                VersionedFlowCoordinates coordinatesB;
                VersionedFlowCoordinates coordinatesA;
                if (valueA instanceof VersionedFlowCoordinates && valueB instanceof VersionedFlowCoordinates && FlowDifferenceUtil.areRegistryUrlsEqual(coordinatesA = (VersionedFlowCoordinates)valueA, coordinatesB = (VersionedFlowCoordinates)valueB) && Objects.equals(coordinatesA.getBucketId(), coordinatesB.getBucketId()) && Objects.equals(coordinatesA.getFlowId(), coordinatesB.getFlowId()) && coordinatesA.getVersion() != coordinatesB.getVersion()) {
                    description = String.format("Flow Version changed from %s to %s", coordinatesA.getVersion(), coordinatesB.getVersion());
                    break;
                }
                description = String.format("From '%s' to '%s'", valueA, valueB);
                break;
            }
            default: {
                description = String.format("From '%s' to '%s'", valueA, valueB);
            }
        }
        return description;
    }
}

