/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpClientProvider;
import com.azure.core.http.okhttp.OkHttpAsyncHttpClientBuilder;
import com.azure.core.util.Configuration;
import com.azure.core.util.HttpClientOptions;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;

public final class OkHttpAsyncClientProvider
implements HttpClientProvider {
    private static final boolean AZURE_ENABLE_HTTP_CLIENT_SHARING = (Boolean)Configuration.getGlobalConfiguration().get("AZURE_ENABLE_HTTP_CLIENT_SHARING", (Object)Boolean.FALSE);
    private final boolean enableHttpClientSharing;

    public OkHttpAsyncClientProvider() {
        this.enableHttpClientSharing = AZURE_ENABLE_HTTP_CLIENT_SHARING;
    }

    OkHttpAsyncClientProvider(Configuration configuration) {
        this.enableHttpClientSharing = (Boolean)configuration.get("AZURE_ENABLE_HTTP_CLIENT_SHARING", (Object)Boolean.FALSE);
    }

    public HttpClient createInstance() {
        if (this.enableHttpClientSharing) {
            return GlobalOkHttpClient.HTTP_CLIENT.getHttpClient();
        }
        return new OkHttpAsyncHttpClientBuilder().build();
    }

    public HttpClient createInstance(HttpClientOptions clientOptions) {
        if (clientOptions == null) {
            return this.createInstance();
        }
        OkHttpAsyncHttpClientBuilder builder = new OkHttpAsyncHttpClientBuilder();
        builder = builder.proxy(clientOptions.getProxyOptions()).configuration(clientOptions.getConfiguration()).connectionTimeout(clientOptions.getConnectTimeout()).writeTimeout(clientOptions.getWriteTimeout()).readTimeout(clientOptions.getReadTimeout());
        Integer poolSize = clientOptions.getMaximumConnectionPoolSize();
        int maximumConnectionPoolSize = poolSize != null && poolSize > 0 ? poolSize : 5;
        ConnectionPool connectionPool = new ConnectionPool(maximumConnectionPoolSize, clientOptions.getConnectionIdleTimeout().toMillis(), TimeUnit.MILLISECONDS);
        builder = builder.connectionPool(connectionPool);
        return builder.build();
    }

    private static enum GlobalOkHttpClient {
        HTTP_CLIENT(new OkHttpAsyncHttpClientBuilder().build());

        private final HttpClient httpClient;

        private GlobalOkHttpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
        }

        private HttpClient getHttpClient() {
            return this.httpClient;
        }
    }
}

