/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.time.Instant;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.InstantEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.InstantQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;

public class NumberToInstantEvaluator
extends InstantEvaluator {
    private final Evaluator<Long> subject;

    public NumberToInstantEvaluator(Evaluator<Long> subject) {
        this.subject = subject;
    }

    @Override
    public QueryResult<Instant> evaluate(EvaluationContext evaluationContext) {
        QueryResult<Long> result = this.subject.evaluate(evaluationContext);
        Long value = result.getValue();
        if (value == null) {
            return new InstantQueryResult(null);
        }
        return new InstantQueryResult(Instant.ofEpochMilli(value));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

