/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue.clustered;

import org.apache.nifi.controller.queue.clustered.TransactionThreshold;

public class SimpleLimitThreshold
implements TransactionThreshold {
    private final int countLimit;
    private final long byteLimit;
    private int count = 0;
    private long bytes = 0L;

    public SimpleLimitThreshold(int count, long bytes) {
        this.countLimit = count;
        this.byteLimit = bytes;
    }

    @Override
    public void adjust(int flowFileCount, long flowFileSize) {
        this.count += flowFileCount;
        this.bytes += flowFileSize;
    }

    @Override
    public boolean isThresholdMet() {
        return this.count >= this.countLimit || this.bytes >= this.byteLimit;
    }
}

