/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.griffin.engine.table.AbstractTreeSetRecordCursorFactory;
import io.questdb.std.IntHashSet;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDeferredTreeSetRecordCursorFactory
extends AbstractTreeSetRecordCursorFactory {
    protected final int columnIndex;
    protected final ObjList<Function> deferredSymbolFuncs;
    protected final IntHashSet deferredSymbolKeys;
    protected final IntHashSet symbolKeys;

    public AbstractDeferredTreeSetRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull DataFrameCursorFactory dataFrameCursorFactory, int columnIndex, ObjList<Function> keyValueFuncs, SymbolMapReader symbolMapReader) {
        super(metadata, dataFrameCursorFactory, configuration);
        int nKeyValues = keyValueFuncs.size();
        IntHashSet symbolKeys = new IntHashSet(nKeyValues);
        IntHashSet deferredSymbolKeys = null;
        ObjList<Function> deferredFuncs = null;
        for (int i = 0; i < nKeyValues; ++i) {
            int symbolKey;
            Function symbolFunc = keyValueFuncs.get(i);
            int n = symbolKey = symbolFunc.isRuntimeConstant() ? -2 : symbolMapReader.keyOf(symbolFunc.getStr(null));
            if (symbolKey == -2) {
                if (deferredFuncs == null) {
                    deferredFuncs = new ObjList<Function>();
                    deferredSymbolKeys = new IntHashSet();
                }
                deferredFuncs.add(symbolFunc);
                continue;
            }
            symbolKeys.add(TableUtils.toIndexKey(symbolKey));
        }
        this.columnIndex = columnIndex;
        this.symbolKeys = symbolKeys;
        this.deferredSymbolKeys = deferredSymbolKeys;
        this.deferredSymbolFuncs = deferredFuncs;
    }

    @Override
    protected AbstractDataFrameRecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        if (this.deferredSymbolFuncs != null) {
            this.deferredSymbolKeys.clear();
            StaticSymbolTable symbolTable = dataFrameCursor.getSymbolTable(this.cursor.columnIndexes.getQuick(this.columnIndex));
            int n = this.deferredSymbolFuncs.size();
            for (int i = 0; i < n; ++i) {
                Function symbolFunc = this.deferredSymbolFuncs.get(i);
                CharSequence symbol = symbolFunc.getStr(null);
                int symbolKey = symbolTable.keyOf(symbol);
                if (symbolKey == -2) continue;
                this.deferredSymbolKeys.add(TableUtils.toIndexKey(symbolKey));
            }
        }
        return super.getCursorInstance(dataFrameCursor, executionContext);
    }
}

