/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.CharConstant;
import io.questdb.griffin.engine.functions.constants.IntConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class StrPosCharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "strpos(SA)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function substrFunc = args.getQuick(1);
        if (substrFunc.isConstant()) {
            char substr = substrFunc.getChar(null);
            if (substr == CharConstant.ZERO.getChar(null)) {
                return IntConstant.NULL;
            }
            return new ConstFunc(args.getQuick(0), substr);
        }
        return new Func(args.getQuick(0), substrFunc);
    }

    private static int strpos(@NotNull CharSequence str, char substr) {
        int strLen = str.length();
        if (strLen < 1) {
            return 0;
        }
        for (int i = 0; i < strLen; ++i) {
            if (str.charAt(i) != substr) continue;
            return i + 1;
        }
        return 0;
    }

    public static class Func
    extends IntFunction
    implements BinaryFunction {
        private final Function strFunc;
        private final Function substrFunc;

        public Func(Function strFunc, Function substrFunc) {
            this.strFunc = strFunc;
            this.substrFunc = substrFunc;
        }

        @Override
        public int getInt(Record rec) {
            CharSequence str = this.strFunc.getStr(rec);
            if (str == null) {
                return Integer.MIN_VALUE;
            }
            char substr = this.substrFunc.getChar(rec);
            if (substr == CharConstant.ZERO.getChar(null)) {
                return Integer.MIN_VALUE;
            }
            return StrPosCharFunctionFactory.strpos(str, substr);
        }

        @Override
        public Function getLeft() {
            return this.strFunc;
        }

        @Override
        public String getName() {
            return "strpos";
        }

        @Override
        public Function getRight() {
            return this.substrFunc;
        }
    }

    public static class ConstFunc
    extends IntFunction
    implements UnaryFunction {
        private final Function strFunc;
        private final char substr;

        public ConstFunc(Function strFunc, char substr) {
            this.strFunc = strFunc;
            this.substr = substr;
        }

        @Override
        public Function getArg() {
            return this.strFunc;
        }

        @Override
        public int getInt(Record rec) {
            CharSequence str = this.strFunc.getStr(rec);
            if (str == null) {
                return Integer.MIN_VALUE;
            }
            return StrPosCharFunctionFactory.strpos(str, this.substr);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("strpos(").val(this.strFunc).val(",'").val(this.substr).val("')");
        }
    }
}

