/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.eq.AbstractEqBinaryFunction;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class EqStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(SS)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function a = args.getQuick(0);
        Function b = args.getQuick(1);
        if (a.isConstant() && !b.isConstant()) {
            return this.createHalfConstantFunc(a, b);
        }
        if (!a.isConstant() && b.isConstant()) {
            return this.createHalfConstantFunc(b, a);
        }
        return new Func(a, b);
    }

    private Function createHalfConstantFunc(Function constFunc, Function varFunc) {
        CharSequence constValue = constFunc.getStr(null);
        if (constValue == null) {
            return new NullCheckFunc(varFunc);
        }
        return new ConstCheckFunc(varFunc, constValue);
    }

    public static class NullCheckFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function arg;

        public NullCheckFunc(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != ((long)this.arg.getStrLen(rec) == -1L);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg);
            if (this.negated) {
                sink.val(" is not null ");
            } else {
                sink.val(" is null");
            }
        }
    }

    private static class Func
    extends AbstractEqBinaryFunction {
        public Func(Function left, Function right) {
            super(left, right);
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence a = this.left.getStr(rec);
            CharSequence b = this.right.getStrB(rec);
            if (a == null) {
                return this.negated != (b == null);
            }
            return this.negated != Chars.equalsNc(a, b);
        }

        @Override
        public String getName() {
            if (this.negated) {
                return "!=";
            }
            return "=";
        }
    }

    private static class ConstCheckFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final CharSequence constant;

        public ConstCheckFunc(Function arg, CharSequence constant) {
            this.arg = arg;
            this.constant = constant;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != Chars.equalsNc(this.constant, this.arg.getStr(rec));
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg);
            if (this.negated) {
                sink.val('!');
            }
            sink.val("='").val(this.constant).val('\'');
        }
    }
}

