/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DateFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.millitime.MillisecondClock;

public class SysdateFunctionFactory
implements FunctionFactory {
    private static final String SIGNATURE = "sysdate()";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(configuration.getMillisecondClock());
    }

    private static class Func
    extends DateFunction
    implements Function {
        private final MillisecondClock clock;

        public Func(MillisecondClock clock) {
            this.clock = clock;
        }

        @Override
        public long getDate(Record rec) {
            return this.clock.getTicks();
        }

        @Override
        public boolean isReadThreadSafe() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(SysdateFunctionFactory.SIGNATURE);
        }
    }
}

