/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.spring;

import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.protocol.impl.NodeProtocolSenderListener;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.FlowSerializationStrategy;
import org.apache.nifi.controller.StandardFlowService;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.services.FlowService;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.revision.RevisionManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class StandardFlowServiceFactoryBean
implements FactoryBean,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private FlowService flowService;
    private NiFiProperties properties;
    private PropertyEncryptor encryptor;
    private Authorizer authorizer;

    public Object getObject() throws Exception {
        if (this.flowService == null) {
            FlowController flowController = (FlowController)this.applicationContext.getBean("flowController", FlowController.class);
            RevisionManager revisionManager = (RevisionManager)this.applicationContext.getBean("revisionManager", RevisionManager.class);
            if (this.properties.isNode()) {
                NodeProtocolSenderListener nodeProtocolSenderListener = (NodeProtocolSenderListener)this.applicationContext.getBean("nodeProtocolSenderListener", NodeProtocolSenderListener.class);
                ClusterCoordinator clusterCoordinator = (ClusterCoordinator)this.applicationContext.getBean("clusterCoordinator", ClusterCoordinator.class);
                this.flowService = StandardFlowService.createClusteredInstance(flowController, this.properties, nodeProtocolSenderListener, clusterCoordinator, revisionManager, this.authorizer);
            } else {
                this.flowService = StandardFlowService.createStandaloneInstance(flowController, this.properties, revisionManager, this.authorizer, FlowSerializationStrategy.WRITE_XML_AND_JSON);
            }
        }
        return this.flowService;
    }

    public Class getObjectType() {
        return FlowService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public void setEncryptor(PropertyEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

