/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.regex;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class NotMatchCharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "!~(Sa)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new MatchFunction(args.getQuick(0), args.getQuick(1).getChar(null));
    }

    private static class MatchFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final char expected;
        private final Function value;

        public MatchFunction(Function value, char expected) {
            this.value = value;
            this.expected = expected;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence cs = this.getArg().getStr(rec);
            return cs != null && Chars.indexOf(cs, this.expected) == -1;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value).val(" !~ '").val(this.expected).val('\'');
        }
    }
}

