/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.DoubleConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class RadiansDoubleFunctionFactory
implements FunctionFactory {
    public static final String SYMBOL = "radians";

    @Override
    public String getSignature() {
        return "radians(D)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function angleDecimal = args.getQuick(0);
        if (angleDecimal.isConstant()) {
            return new DoubleConstant(Math.toRadians(angleDecimal.getDouble(null)));
        }
        return new Radians(args.getQuick(0));
    }

    private static class Radians
    extends DoubleFunction
    implements UnaryFunction {
        final Function function;

        public Radians(Function function) {
            this.function = function;
        }

        @Override
        public Function getArg() {
            return this.function;
        }

        @Override
        public double getDouble(Record rec) {
            return Math.toRadians(this.function.getDouble(rec));
        }

        @Override
        public String getName() {
            return RadiansDoubleFunctionFactory.SYMBOL;
        }
    }
}

