/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cutlass.text.AtomicBooleanCircuitBreaker;
import io.questdb.std.Rnd;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import java.util.concurrent.atomic.AtomicLong;

public class TextImportExecutionContext {
    public static final long INACTIVE = -1L;
    private final AtomicLong activeImportId = new AtomicLong(-1L);
    private final AtomicBooleanCircuitBreaker circuitBreaker = new AtomicBooleanCircuitBreaker();
    private final Rnd rnd;

    public TextImportExecutionContext(CairoConfiguration configuration) {
        MicrosecondClock clock = configuration.getMicrosecondClock();
        this.rnd = new Rnd(clock.getTicks(), clock.getTicks());
    }

    public long assignActiveImportId() {
        long nextId = this.rnd.nextPositiveLong();
        this.activeImportId.set(nextId);
        return nextId;
    }

    public long getActiveImportId() {
        return this.activeImportId.get();
    }

    public AtomicBooleanCircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public void resetActiveImportId() {
        this.activeImportId.set(-1L);
    }
}

