/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter;

import java.util.List;
import org.apache.nifi.parameter.EscapedParameterReference;
import org.apache.nifi.parameter.ParameterParser;
import org.apache.nifi.parameter.ParameterToken;
import org.apache.nifi.parameter.StandardParameterReference;
import org.apache.nifi.parameter.StartCharacterEscape;

public abstract class AbstractParameterParser
implements ParameterParser {
    protected static final char START_TAG = '#';
    protected static final char OPEN_BRACE = '{';
    protected static final char CLOSE_BRACE = '}';

    protected ParameterToken parseParameterToken(String input, int startIndex, int sequentialStartTags, List<ParameterToken> tokens) {
        ParameterToken token;
        int startCharIndex = startIndex - sequentialStartTags;
        int endCharIndex = input.indexOf(125, startIndex);
        if (endCharIndex < 0) {
            return null;
        }
        int numEscapedStartTags = (sequentialStartTags - 1) / 2;
        int startOffset = startCharIndex + numEscapedStartTags * 2;
        String referenceText = input.substring(startOffset, endCharIndex + 1);
        for (int escapes = 0; escapes < numEscapedStartTags; ++escapes) {
            tokens.add(new StartCharacterEscape(startCharIndex + escapes * 2));
        }
        if (sequentialStartTags % 2 == 1) {
            String parameterName = input.substring(startCharIndex + sequentialStartTags + 1, endCharIndex);
            token = new StandardParameterReference(parameterName, startOffset, endCharIndex, referenceText);
        } else {
            token = new EscapedParameterReference(startOffset, endCharIndex, referenceText);
        }
        tokens.add(token);
        return token;
    }
}

