/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Key;
import java.security.PublicKey;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sshd.cli.CliLogger;
import org.apache.sshd.cli.CliSupport;
import org.apache.sshd.cli.client.CliClientModuleProperties;
import org.apache.sshd.client.ClientAuthenticationManager;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.config.SshClientConfigFileReader;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.client.config.keys.ClientIdentity;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.keyverifier.DefaultKnownHostsServerKeyVerifier;
import org.apache.sshd.client.keyverifier.KnownHostsServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.PtyChannelConfiguration;
import org.apache.sshd.common.channel.PtyChannelConfigurationMutator;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.config.ConfigFileReaderSupport;
import org.apache.sshd.common.config.SshConfigFileReader;
import org.apache.sshd.common.config.keys.BuiltinIdentities;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.kex.KexFactoryManager;
import org.apache.sshd.common.kex.extension.DefaultClientKexExtensionHandler;
import org.apache.sshd.common.kex.extension.KexExtensionHandler;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ReflectionUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.output.NoCloseOutputStream;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.common.util.threads.ThreadUtils;

public abstract class SshClientCliSupport
extends CliSupport {
    public static final String SSH_CLIENT_PORT_OPTION = "-p";

    protected SshClientCliSupport() {
    }

    public static boolean isArgumentedOption(String portOption, String argName) {
        return portOption.equals(argName) || "-io".equals(argName) || "-i".equals(argName) || "-o".equals(argName) || "-l".equals(argName) || "-w".equals(argName) || "-c".equals(argName) || "-C".equals(argName) || "-m".equals(argName) || "-E".equals(argName) || "-J".equals(argName);
    }

    public static ClientSession setupClientSession(String portOption, BufferedReader stdin, Level level, PrintStream stdout, PrintStream stderr, String ... args) throws Exception {
        int port = -1;
        String host = null;
        String login = null;
        String proxyJump = null;
        String password = null;
        boolean error = false;
        ArrayList<Path> identities = new ArrayList<Path>();
        TreeMap<String, Object> options = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        List<NamedFactory<Cipher>> ciphers = null;
        List<NamedFactory<Mac>> macs = null;
        List<NamedFactory<Compression>> compressions = null;
        int numArgs = GenericUtils.length((Object[])args);
        for (int i = 0; !error && i < numArgs; ++i) {
            String argName = args[i];
            String argVal = null;
            if (SshClientCliSupport.isArgumentedOption(portOption, argName)) {
                if (++i >= numArgs) {
                    error = CliLogger.showError(stderr, "option requires an argument: " + argName);
                    break;
                }
                argVal = args[i];
            }
            if (portOption.equals(argName)) {
                if (port > 0) {
                    error = CliLogger.showError(stderr, argName + " option value re-specified: " + port);
                    break;
                }
                port = Integer.parseInt(argVal);
                if (port > 0) continue;
                error = CliLogger.showError(stderr, "Bad option value for " + argName + ": " + port);
                break;
            }
            if ("-J".equals(argName)) {
                if (proxyJump != null) {
                    error = CliLogger.showError(stderr, argName + " option value re-specified: " + proxyJump);
                    break;
                }
                proxyJump = argVal;
                continue;
            }
            if ("-w".equals(argName)) {
                if (GenericUtils.length(password) > 0) {
                    error = CliLogger.showError(stderr, argName + " option value re-specified: " + password);
                    break;
                }
                password = argVal;
                continue;
            }
            if ("-c".equals(argName)) {
                if (!GenericUtils.isEmpty(ciphers = SshClientCliSupport.setupCiphers(argName, argVal, ciphers, stderr))) continue;
                error = true;
                break;
            }
            if ("-m".equals(argName)) {
                if (!GenericUtils.isEmpty(macs = SshClientCliSupport.setupMacs(argName, argVal, macs, stderr))) continue;
                error = true;
                break;
            }
            if ("-i".equals(argName)) {
                Path idFile = SshClientCliSupport.resolveIdentityFile(argVal);
                identities.add(idFile);
                continue;
            }
            if ("-C".equals(argName)) {
                if (!GenericUtils.isEmpty(compressions = SshClientCliSupport.setupCompressions(argName, argVal, compressions, stderr))) continue;
                error = true;
                break;
            }
            if ("-o".equals(argName)) {
                String opt = argVal;
                int idx = opt.indexOf(61);
                if (idx <= 0) {
                    error = CliLogger.showError(stderr, "bad syntax for option: " + opt);
                    break;
                }
                String optName = opt.substring(0, idx);
                String optValue = opt.substring(idx + 1);
                if ("IdentityFile".equals(optName)) {
                    Path idFile = SshClientCliSupport.resolveIdentityFile(optValue);
                    identities.add(idFile);
                    continue;
                }
                options.merge(optName, optValue, (a, b) -> a + "," + b);
                continue;
            }
            if ("-l".equals(argName)) {
                if (login != null) {
                    error = CliLogger.showError(stderr, argName + " option value re-specified: " + port);
                    break;
                }
                login = argVal;
                continue;
            }
            if (argName.charAt(0) == '-') continue;
            if (host != null) break;
            host = argName;
            int pos = host.indexOf(64);
            if (pos <= 0) continue;
            if (login == null) {
                login = host.substring(0, pos);
                host = host.substring(pos + 1);
                continue;
            }
            error = CliLogger.showError(stderr, "Login already specified using -l option (" + login + "): " + host);
            break;
        }
        if (!error && GenericUtils.isEmpty(host)) {
            error = CliLogger.showError(stderr, "Hostname not specified");
        }
        if (error) {
            return null;
        }
        PropertyResolver resolver = PropertyResolverUtils.toPropertyResolver(options);
        SshClient client = SshClientCliSupport.setupClient(resolver, ciphers, macs, compressions, identities, stdin, stdout, stderr, level, args);
        if (client == null) {
            return null;
        }
        try {
            client.start();
            if (login == null) {
                login = OsUtils.getCurrentUser();
            }
            port = SshConstants.TO_EFFECTIVE_PORT.applyAsInt(port);
            HostConfigEntry entry = SshClientCliSupport.resolveHost((ClientFactoryManager)client, login, host, port, proxyJump);
            ClientSession session = (ClientSession)((ConnectFuture)client.connect(entry, null, null).verify((Duration)CliClientModuleProperties.CONECT_TIMEOUT.getRequired((PropertyResolver)client), new CancelOption[0])).getSession();
            try {
                if (GenericUtils.length((CharSequence)password) > 0) {
                    session.addPasswordIdentity(password);
                }
                session.auth().verify((Duration)CliClientModuleProperties.AUTH_TIMEOUT.getRequired((PropertyResolver)session), new CancelOption[0]);
                return session;
            }
            catch (Exception e) {
                session.close(true);
                throw e;
            }
        }
        catch (Exception e) {
            client.close();
            throw e;
        }
    }

    public static HostConfigEntry resolveHost(ClientFactoryManager client, String username, String host, int port, String proxyJump) throws IOException {
        HostConfigEntryResolver resolver = client.getHostConfigEntryResolver();
        HostConfigEntry entry = resolver.resolveEffectiveHost(host, port, null, username, proxyJump, null);
        if (entry == null) {
            entry = SshdSocketAddress.isIPv6Address((String)host) ? new HostConfigEntry("", host, port, username, null) : new HostConfigEntry(host, host, port, username, proxyJump);
        }
        return entry;
    }

    public static Path resolveIdentityFile(String id) throws IOException {
        BuiltinIdentities identity = BuiltinIdentities.fromName((String)id);
        if (identity != null) {
            String fileName = ClientIdentity.getIdentityFileName((String)identity.getName());
            Path keysFolder = PublicKeyEntry.getDefaultKeysFolderPath();
            return keysFolder.resolve(fileName);
        }
        return Paths.get(id, new String[0]);
    }

    public static Map<String, ?> resolveClientEnvironment(PropertyResolver resolver) {
        return SshClientCliSupport.resolveClientEnvironment(resolver == null ? Collections.emptyMap() : resolver.getProperties());
    }

    public static Map<String, ?> resolveClientEnvironment(Map<String, ?> options) {
        if (MapEntryUtils.isEmpty(options)) {
            return Collections.emptyMap();
        }
        Map<String, String> env = Collections.emptyMap();
        for (String propName : new String[]{"SetEnv", "SendEnv"}) {
            String[] kvp;
            Object v = options.get(propName);
            String s = Objects.toString(v, null);
            if (GenericUtils.isEmpty((CharSequence)s)) continue;
            for (String kve : kvp = GenericUtils.split((String)s, (char)',')) {
                String prev;
                String value;
                int pos = kve.indexOf(61);
                String key = pos >= 0 ? kve.substring(0, pos) : kve;
                String string = value = pos >= 0 ? kve.substring(pos + 1) : "";
                if (env.isEmpty()) {
                    env = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                }
                if ((prev = env.put(key, value)) == null) continue;
            }
        }
        return env;
    }

    public static PtyChannelConfiguration resolveClientPtyOptions(PropertyResolver resolver) throws IOException, InterruptedException {
        return SshClientCliSupport.resolveClientPtyOptions(resolver == null ? Collections.emptyMap() : resolver.getProperties());
    }

    public static PtyChannelConfiguration resolveClientPtyOptions(Map<String, ?> options) throws IOException, InterruptedException {
        Map<PtyMode, Integer> ptyModes;
        Boolean ptyEnabled;
        Object v = MapEntryUtils.isEmpty(options) ? null : options.get("RequestTTY");
        String s = Objects.toString(v, "auto");
        boolean autoDetect = "auto".equalsIgnoreCase(s);
        Boolean bl = ptyEnabled = autoDetect ? Boolean.TRUE : PropertyResolverUtils.parseBoolean((String)s);
        if (ptyEnabled == null || !ptyEnabled.booleanValue()) {
            return null;
        }
        PtyChannelConfiguration config = new PtyChannelConfiguration();
        if (autoDetect) {
            PtyChannelConfigurationMutator.setupSensitiveDefaultPtyConfiguration((PtyChannelConfigurationMutator)config);
        }
        if (MapEntryUtils.isNotEmpty(ptyModes = SshClientCliSupport.resolveClientPtyModes(options))) {
            config.setPtyModes(ptyModes);
        }
        return config;
    }

    public static Map<PtyMode, Integer> resolveClientPtyModes(Map<String, ?> options) throws IOException, InterruptedException {
        Object v = MapEntryUtils.isEmpty(options) ? null : options.get(PtyMode.class.getSimpleName());
        String s = Objects.toString(v, null);
        if (GenericUtils.isEmpty((CharSequence)s)) {
            return Collections.emptyMap();
        }
        String[] kvp = GenericUtils.split((String)s, (char)',');
        EnumMap<PtyMode, Integer> ptyModes = new EnumMap<PtyMode, Integer>(PtyMode.class);
        for (String kve : kvp) {
            Integer value;
            int pos = kve.indexOf(61);
            String key = pos >= 0 ? kve.substring(0, pos) : kve;
            PtyMode mode = (PtyMode)ValidateUtils.checkNotNull((Object)PtyMode.fromName((String)key), (String)"Unknown PTY mode: %s", (Object)key);
            Integer prev = ptyModes.put(mode, value = GenericUtils.isEmpty((CharSequence)(s = pos >= 0 ? kve.substring(pos + 1) : "")) ? Integer.valueOf(1) : Integer.valueOf(s));
            if (prev == null) continue;
        }
        return ptyModes;
    }

    public static SshClient setupDefaultClient(PropertyResolver resolver, Level level, PrintStream stdout, PrintStream stderr, String ... args) {
        SshClient client = SshClientCliSupport.setupIoServiceFactory(SshClient.setUpDefaultClient(), resolver, level, stdout, stderr, args);
        SshConfigFileReader.configureKeyExchanges((AbstractFactoryManager)client, (PropertyResolver)resolver, (boolean)true, (Function)ClientBuilder.DH2KEX, (boolean)true);
        SshConfigFileReader.configureSignatures((AbstractFactoryManager)client, (PropertyResolver)resolver, (boolean)true, (boolean)true);
        SshClientConfigFileReader.setupClientHeartbeat((SshClient)client, (PropertyResolver)resolver);
        return client;
    }

    public static SshClient setupClient(PropertyResolver resolver, List<NamedFactory<Cipher>> ciphers, List<NamedFactory<Mac>> macs, List<NamedFactory<Compression>> compressions, Collection<? extends Path> identities, BufferedReader stdin, PrintStream stdout, PrintStream stderr, Level level, String[] args) throws Exception {
        if (GenericUtils.isEmpty(ciphers) && (ciphers = SshClientCliSupport.setupCiphers(resolver, stderr)) == null) {
            return null;
        }
        if (GenericUtils.isEmpty(macs) && (macs = SshClientCliSupport.setupMacs(resolver, stderr)) == null) {
            return null;
        }
        if (GenericUtils.isEmpty(compressions) && (compressions = SshClientCliSupport.setupCompressions(resolver, stderr)) == null) {
            return null;
        }
        SshClient client = SshClientCliSupport.setupDefaultClient(resolver, level, stdout, stderr, args);
        if (client == null) {
            return null;
        }
        try {
            if (GenericUtils.size(ciphers) > 0) {
                client.setCipherFactories(ciphers);
            }
            if (GenericUtils.size(macs) > 0) {
                client.setMacFactories(macs);
            }
            if (GenericUtils.size(compressions) > 0) {
                client.setCompressionFactories(compressions);
            }
            try {
                SshClientCliSupport.setupSessionIdentities((ClientFactoryManager)client, identities, stdin, stdout, stderr);
            }
            catch (Throwable t) {
                CliLogger.showError(stderr, t.getClass().getSimpleName() + " while loading user keys: " + t.getMessage());
            }
            SshClientCliSupport.setupServerKeyVerifier((ClientAuthenticationManager)client, resolver, stdin, stdout, stderr);
            SshClientCliSupport.setupUserAuthFactories(client, resolver);
            SshClientCliSupport.setupSessionUserInteraction((ClientAuthenticationManager)client, stdin, stdout, stderr);
            SshClientCliSupport.setupSessionExtensions((KexFactoryManager)client, resolver, stdin, stdout, stderr);
            Map options = resolver.getProperties();
            if (MapEntryUtils.isNotEmpty((Map)options)) {
                Map props = client.getProperties();
                props.putAll(options);
            }
            return client;
        }
        catch (Throwable t) {
            CliLogger.showError(stderr, "Failed (" + t.getClass().getSimpleName() + ") to setup client: " + t.getMessage());
            client.close();
            return null;
        }
    }

    public static FileKeyPairProvider setupSessionIdentities(ClientFactoryManager client, Collection<? extends Path> identities, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Throwable {
        client.setFilePasswordProvider((session, file, index) -> {
            stdout.print("Enter password for private key file=" + file + ": ");
            return stdin.readLine();
        });
        if (GenericUtils.isEmpty(identities)) {
            return null;
        }
        FileKeyPairProvider provider = new FileKeyPairProvider(){

            public String toString() {
                return FileKeyPairProvider.class.getSimpleName() + "[clientIdentitiesProvider]";
            }
        };
        provider.setPaths(identities);
        client.setKeyIdentityProvider((KeyIdentityProvider)provider);
        return provider;
    }

    public static UserInteraction setupSessionUserInteraction(ClientAuthenticationManager client, final BufferedReader stdin, final PrintStream stdout, final PrintStream stderr) {
        UserInteraction ui = new UserInteraction(){

            public boolean isInteractionAllowed(ClientSession session) {
                return true;
            }

            public void serverVersionInfo(ClientSession session, List<String> lines) {
                for (String l : lines) {
                    stdout.append('\t').println(l);
                }
            }

            public void welcome(ClientSession clientSession, String banner, String lang) {
                stdout.println(banner);
            }

            public String[] interactive(ClientSession clientSession, String name, String instruction, String lang, String[] prompt, boolean[] echo) {
                int numPropmts = GenericUtils.length((Object[])prompt);
                String[] answers = new String[numPropmts];
                try {
                    for (int i = 0; i < numPropmts; ++i) {
                        stdout.append(prompt[i]).print(" ");
                        answers[i] = stdin.readLine();
                    }
                }
                catch (IOException e) {
                    stderr.append("WARNING: ").append(e.getClass().getSimpleName()).append(" while read prompts: ").println(e.getMessage());
                }
                return answers;
            }

            public String getUpdatedPassword(ClientSession clientSession, String prompt, String lang) {
                stdout.append(prompt).print(" ");
                try {
                    return stdin.readLine();
                }
                catch (IOException e) {
                    stderr.append("WARNING: ").append(e.getClass().getSimpleName()).append(" while read password: ").println(e.getMessage());
                    return null;
                }
            }
        };
        client.setUserInteraction(ui);
        return ui;
    }

    public static void setupSessionExtensions(KexFactoryManager manager, PropertyResolver resolver, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
        Map options = resolver.getProperties();
        String kexExtension = Objects.toString(options.remove(KexExtensionHandler.class.getSimpleName()), null);
        if (GenericUtils.isEmpty((CharSequence)kexExtension)) {
            return;
        }
        if ("default".equalsIgnoreCase(kexExtension)) {
            manager.setKexExtensionHandler((KexExtensionHandler)DefaultClientKexExtensionHandler.INSTANCE);
            stdout.println("Using " + DefaultClientKexExtensionHandler.class.getSimpleName());
        } else {
            ClassLoader cl = ThreadUtils.resolveDefaultClassLoader(KexExtensionHandler.class);
            try {
                Class<?> clazz = cl.loadClass(kexExtension);
                KexExtensionHandler handler = (KexExtensionHandler)ReflectionUtils.newInstance(clazz, KexExtensionHandler.class);
                manager.setKexExtensionHandler(handler);
            }
            catch (Exception e) {
                stderr.append("ERROR: Failed (").append(e.getClass().getSimpleName()).append(')').append(" to instantiate KEX extension handler=").append(kexExtension).append(": ").println(e.getMessage());
                stderr.flush();
                throw e;
            }
            stdout.println("Using " + KexExtensionHandler.class.getSimpleName() + "=" + kexExtension);
        }
    }

    public static ServerKeyVerifier setupServerKeyVerifier(ClientAuthenticationManager manager, PropertyResolver resolver, BufferedReader stdin, PrintStream stdout, PrintStream stderr) {
        Map options;
        String strictValue;
        ServerKeyVerifier current = manager.getServerKeyVerifier();
        if (current == null) {
            current = ClientBuilder.DEFAULT_SERVER_KEY_VERIFIER;
            manager.setServerKeyVerifier(current);
        }
        if (!ConfigFileReaderSupport.parseBooleanValue((String)(strictValue = Objects.toString((options = resolver.getProperties()).remove("StrictHostKeyChecking"), "true")))) {
            return current;
        }
        String filePath = Objects.toString(options.remove("UserKnownHostsFile"), null);
        current = GenericUtils.isEmpty((CharSequence)filePath) ? new DefaultKnownHostsServerKeyVerifier(current) : new DefaultKnownHostsServerKeyVerifier(current, false, Paths.get(filePath, new String[0]), new LinkOption[0]);
        ((KnownHostsServerKeyVerifier)current).setModifiedServerKeyAcceptor((clientSession, remoteAddress, entry, expected, actual) -> {
            stderr.append("WARNING: Mismatched keys presented by ").append(Objects.toString(remoteAddress)).append(" for entry=").println(entry);
            stderr.append("    ").append("Expected=").append(KeyUtils.getKeyType((Key)expected)).append('-').println(KeyUtils.getFingerPrint((PublicKey)expected));
            stderr.append("    ").append("Actual=").append(KeyUtils.getKeyType((Key)actual)).append('-').println(KeyUtils.getFingerPrint((PublicKey)actual));
            stderr.flush();
            stdout.append("Accept key and update known hosts: y/[N]");
            stdout.flush();
            String ans = GenericUtils.trimToEmpty((String)stdin.readLine());
            return GenericUtils.length((CharSequence)ans) > 0 && Character.toLowerCase(ans.charAt(0)) == 'y';
        });
        manager.setServerKeyVerifier(current);
        return current;
    }

    public static OutputStream resolveLoggingTargetStream(PrintStream stdout, PrintStream stderr, String ... args) {
        return SshClientCliSupport.resolveLoggingTargetStream(stdout, stderr, args, GenericUtils.length((Object[])args));
    }

    public static OutputStream resolveLoggingTargetStream(PrintStream stdout, PrintStream stderr, String[] args, int maxIndex) {
        for (int index = 0; index < maxIndex; ++index) {
            String argName = args[index];
            if (!"-E".equals(argName)) continue;
            if (index + 1 >= maxIndex) {
                CliLogger.showError(stderr, "Missing " + argName + " option argument");
                return null;
            }
            String argVal = args[index + 1];
            if ("--".equals(argVal)) {
                return stdout;
            }
            try {
                Path path = Paths.get(argVal, new String[0]).normalize().toAbsolutePath();
                return Files.newOutputStream(path, new OpenOption[0]);
            }
            catch (IOException e) {
                CliLogger.showError(stderr, "Failed (" + e.getClass().getSimpleName() + ") to open " + argVal + ": " + e.getMessage());
                return null;
            }
        }
        return stderr;
    }

    public static Handler setupLogging(Level level, final PrintStream stdout, final PrintStream stderr, final OutputStream outputStream) {
        ConsoleHandler fh = new ConsoleHandler(){
            {
                this.setOutputStream(outputStream);
            }

            @Override
            protected synchronized void setOutputStream(OutputStream out) throws SecurityException {
                if (out == stdout || out == stderr) {
                    super.setOutputStream((OutputStream)new NoCloseOutputStream(out));
                } else {
                    super.setOutputStream(out);
                }
            }
        };
        fh.setLevel(Level.FINEST);
        fh.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord logRecord) {
                String message = this.formatMessage(logRecord);
                String throwable = "";
                Throwable t = logRecord.getThrown();
                if (t != null) {
                    StringWriter sw = new StringWriter();
                    try (PrintWriter pw = new PrintWriter(sw);){
                        pw.println();
                        t.printStackTrace(pw);
                    }
                    throwable = sw.toString();
                }
                return String.format("%1$tY-%1$tm-%1$td: %2$-7.7s: %3$-32.32s: %4$s%5$s%n", new Date(logRecord.getMillis()), logRecord.getLevel().getName(), logRecord.getLoggerName(), message, throwable);
            }
        });
        Logger root = Logger.getLogger("");
        for (Handler handler : root.getHandlers()) {
            root.removeHandler(handler);
        }
        root.addHandler(fh);
        root.setLevel(level);
        return fh;
    }
}

