/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.secdispatcher.internal.cipher;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.components.secdispatcher.Cipher;
import org.codehaus.plexus.components.secdispatcher.CipherException;

@Singleton
@Named(value="AES/GCM/NoPadding")
public class AESGCMNoPadding
implements Cipher {
    public static final String CIPHER_ALG = "AES/GCM/NoPadding";
    private static final int TAG_LENGTH_BIT = 128;
    private static final int IV_LENGTH_BYTE = 12;
    private static final int SALT_LENGTH_BYTE = 16;
    private static final int PBE_ITERATIONS = 310000;
    private static final int PBE_KEY_SIZE = 256;
    private static final String KEY_FACTORY = "PBKDF2WithHmacSHA512";
    private static final String KEY_ALGORITHM = "AES";

    @Override
    public String encrypt(String clearText, String password) throws CipherException {
        try {
            byte[] salt = AESGCMNoPadding.getRandomNonce(16);
            byte[] iv = AESGCMNoPadding.getRandomNonce(12);
            SecretKey secretKey = AESGCMNoPadding.getAESKeyFromPassword(password.toCharArray(), salt);
            javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance(CIPHER_ALG);
            cipher.init(1, (Key)secretKey, new GCMParameterSpec(128, iv));
            byte[] cipherText = cipher.doFinal(clearText.getBytes(StandardCharsets.UTF_8));
            byte[] cipherTextWithIvSalt = ByteBuffer.allocate(iv.length + salt.length + cipherText.length).put(iv).put(salt).put(cipherText).array();
            return Base64.getEncoder().encodeToString(cipherTextWithIvSalt);
        }
        catch (Exception e) {
            throw new CipherException("Failed encrypting", e);
        }
    }

    @Override
    public String decrypt(String encryptedText, String password) throws CipherException {
        try {
            byte[] material = Base64.getDecoder().decode(encryptedText.getBytes(StandardCharsets.UTF_8));
            ByteBuffer buffer = ByteBuffer.wrap(material);
            byte[] iv = new byte[12];
            buffer.get(iv);
            byte[] salt = new byte[16];
            buffer.get(salt);
            byte[] cipherText = new byte[buffer.remaining()];
            buffer.get(cipherText);
            SecretKey secretKey = AESGCMNoPadding.getAESKeyFromPassword(password.toCharArray(), salt);
            javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance(CIPHER_ALG);
            cipher.init(2, (Key)secretKey, new GCMParameterSpec(128, iv));
            byte[] plainText = cipher.doFinal(cipherText);
            return new String(plainText, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new CipherException("Failed decrypting", e);
        }
    }

    private static byte[] getRandomNonce(int numBytes) throws NoSuchAlgorithmException {
        byte[] nonce = new byte[numBytes];
        SecureRandom.getInstanceStrong().nextBytes(nonce);
        return nonce;
    }

    private static SecretKey getAESKeyFromPassword(char[] password, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(KEY_FACTORY);
        PBEKeySpec spec = new PBEKeySpec(password, salt, 310000, 256);
        return new SecretKeySpec(factory.generateSecret(spec).getEncoded(), KEY_ALGORITHM);
    }
}

