/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.cache.impl;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mvndaemon.mvnd.cache.Cache;
import org.mvndaemon.mvnd.cache.CacheFactory;
import org.mvndaemon.mvnd.cache.CacheRecord;

public class TimestampCacheFactory
implements CacheFactory {
    @Override
    public <K, V extends CacheRecord> Cache<K, V> newCache() {
        return new TimestampCache();
    }

    static class TimestampCache<K, V extends CacheRecord>
    implements Cache<K, V> {
        private final ConcurrentHashMap<K, Record<V>> map = new ConcurrentHashMap();

        TimestampCache() {
        }

        @Override
        public boolean contains(K key) {
            return this.get(key) != null;
        }

        @Override
        public V get(K key) {
            Record record = this.map.compute(key, (k, v) -> {
                if (v != null) {
                    try {
                        Set currentFileStates = ((Record)v).currentFileStates();
                        if (Objects.equals(v.fileStates, currentFileStates)) {
                            return v;
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    v.record.invalidate();
                    v = null;
                }
                return v;
            });
            return record != null ? (V)record.record : null;
        }

        @Override
        public void put(K key, V value) {
            this.map.put(key, new Record<V>(value));
        }

        @Override
        public void clear() {
            this.removeIf((k, v) -> true);
        }

        @Override
        public void removeIf(BiPredicate<K, V> predicate) {
            Iterator<Map.Entry<K, Record<V>>> iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<K, Record<V>> entry = iterator.next();
                if (!predicate.test(entry.getKey(), entry.getValue().record)) continue;
                entry.getValue().record.invalidate();
                iterator.remove();
            }
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            return this.map.compute(key, (BiFunction<Object, Record, Record>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$computeIfAbsent$2(java.util.function.Function java.lang.Object org.mvndaemon.mvnd.cache.impl.TimestampCacheFactory$Record ), (Ljava/lang/Object;Lorg/mvndaemon/mvnd/cache/impl/TimestampCacheFactory$Record;)Lorg/mvndaemon/mvnd/cache/impl/TimestampCacheFactory$Record;)(mappingFunction)).record;
        }

        private static /* synthetic */ Record lambda$computeIfAbsent$2(Function mappingFunction, Object k, Record v) {
            if (v != null) {
                try {
                    if (Objects.equals(v.fileStates, v.currentFileStates())) {
                        return v;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                v.record.invalidate();
                v = null;
            }
            return new Record<CacheRecord>((CacheRecord)mappingFunction.apply(k));
        }
    }

    static class Record<V extends CacheRecord> {
        final V record;
        final Set<FileState> fileStates;

        public Record(V record) {
            this.record = record;
            this.fileStates = this.currentFileStates();
        }

        private Set<FileState> currentFileStates() {
            return this.record.getDependencyPaths().map(FileState::new).collect(Collectors.toSet());
        }
    }

    static class FileState {
        final Path path;
        final FileTime lastModifiedTime;
        final Object fileKey;

        FileState(Path path) {
            BasicFileAttributes attrs;
            this.path = path;
            try {
                attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (NoSuchFileException e) {
                attrs = null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.lastModifiedTime = attrs != null ? attrs.lastModifiedTime() : FileTime.fromMillis(0L);
            this.fileKey = attrs != null ? attrs.fileKey() : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileState that = (FileState)o;
            return this.path.equals(that.path) && Objects.equals(this.lastModifiedTime, that.lastModifiedTime) && Objects.equals(this.fileKey, that.fileKey);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.lastModifiedTime, this.fileKey);
        }

        public String toString() {
            return "FileState [path=" + this.path + ", lastModifiedTime=" + this.lastModifiedTime + ", fileKey=" + this.fileKey + "]";
        }
    }
}

