/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.net.PortBased;
import org.apache.log4j.net.ZeroConfSupport;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.xml.XMLLayout;

public class MulticastAppender
extends AppenderSkeleton
implements PortBased {
    static final int DEFAULT_PORT = 9991;
    public static final String ZONE = "_log4j_xml_mcast_appender.local.";
    String hostname;
    String remoteHost;
    String application;
    int timeToLive;
    InetAddress address;
    int port = 9991;
    MulticastSocket outSocket;
    private String encoding;
    private boolean locationInfo = false;
    private boolean advertiseViaMulticastDNS;
    private ZeroConfSupport zeroConf;

    public MulticastAppender() {
        super(false);
    }

    @Override
    public void activateOptions() {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            try {
                this.hostname = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException uhe2) {
                this.hostname = "unknown";
            }
        }
        if (this.application == null) {
            this.application = System.getProperty("application");
        } else if (System.getProperty("application") != null) {
            this.application = this.application + "-" + System.getProperty("application");
        }
        if (this.remoteHost == null) {
            String err = "The RemoteHost property is required for MulticastAppender named " + this.name;
            LogLog.error(err);
            throw new IllegalStateException(err);
        }
        this.address = this.getAddressByName(this.remoteHost);
        if (this.layout == null) {
            this.layout = new XMLLayout();
        }
        if (this.advertiseViaMulticastDNS) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("multicastAddress", this.remoteHost);
            this.zeroConf = new ZeroConfSupport(ZONE, this.port, this.getName(), properties);
            this.zeroConf.advertise();
        }
        this.connect();
        super.activateOptions();
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.advertiseViaMulticastDNS) {
            this.zeroConf.unadvertise();
        }
        this.cleanUp();
    }

    public void cleanUp() {
        if (this.outSocket != null) {
            try {
                this.outSocket.close();
            }
            catch (Exception e) {
                LogLog.error("Could not close outSocket.", e);
            }
            this.outSocket = null;
        }
    }

    void connect() {
        if (this.address == null) {
            return;
        }
        try {
            this.cleanUp();
            this.outSocket = new MulticastSocket();
            this.outSocket.setTimeToLive(this.timeToLive);
        }
        catch (IOException e) {
            LogLog.error("Error in connect method of MulticastAppender named " + this.name, e);
        }
    }

    @Override
    public void append(LoggingEvent event) {
        if (event == null) {
            return;
        }
        if (this.locationInfo) {
            event.getLocationInformation();
        }
        if (this.outSocket != null) {
            event.setProperty("hostname", this.hostname);
            if (this.application != null) {
                event.setProperty("application", this.application);
            }
            if (this.locationInfo) {
                event.getLocationInformation();
            }
            try {
                StringBuilder buf = new StringBuilder(this.layout.format(event));
                byte[] payload = this.encoding == null ? buf.toString().getBytes() : buf.toString().getBytes(this.encoding);
                DatagramPacket dp = new DatagramPacket(payload, payload.length, this.address, this.port);
                this.outSocket.send(dp);
            }
            catch (IOException e) {
                this.outSocket = null;
                LogLog.warn("Detected problem with Multicast connection: " + e);
            }
        }
    }

    InetAddress getAddressByName(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (Exception e) {
            LogLog.error("Could not find address of [" + host + "].", e);
            return null;
        }
    }

    public void setRemoteHost(String host) {
        this.remoteHost = host;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setLocationInfo(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setApplication(String app) {
        this.application = app;
    }

    public String getApplication() {
        return this.application;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean requiresLayout() {
        return true;
    }

    public boolean isAdvertiseViaMulticastDNS() {
        return this.advertiseViaMulticastDNS;
    }

    public void setAdvertiseViaMulticastDNS(boolean advertiseViaMulticastDNS) {
        this.advertiseViaMulticastDNS = advertiseViaMulticastDNS;
    }
}

