/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.annotations.BatchFetch;
import org.eclipse.persistence.annotations.CascadeOnDelete;
import org.eclipse.persistence.annotations.Convert;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.Noncacheable;
import org.eclipse.persistence.annotations.PrivateOwned;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProcessor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.ForeignKeyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinFieldMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.RelationalColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.mappings.BatchFetchMetadata;
import org.eclipse.persistence.internal.jpa.metadata.mappings.CascadeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.JoinTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.RelationTableMechanism;

public abstract class RelationshipAccessor
extends MappingAccessor {
    private Boolean m_orphanRemoval;
    private Boolean m_cascadeOnDelete;
    private Boolean m_nonCacheable;
    private Boolean m_privateOwned;
    private BatchFetchMetadata m_batchFetch;
    private CascadeMetadata m_cascade;
    private ForeignKeyMetadata m_foreignKey;
    private JoinTableMetadata m_joinTable;
    protected MetadataClass m_referenceClass;
    private MetadataClass m_targetEntity;
    private List<JoinColumnMetadata> m_joinColumns = new ArrayList<JoinColumnMetadata>();
    private List<JoinFieldMetadata> m_joinFields = new ArrayList<JoinFieldMetadata>();
    private String m_fetch;
    private String m_mappedBy;
    private String m_joinFetch;
    private String m_targetEntityName;

    protected RelationshipAccessor(String xmlElement) {
        super(xmlElement);
    }

    protected RelationshipAccessor(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor);
        Object joinColumn;
        int n;
        this.m_fetch = annotation == null ? this.getDefaultFetchType() : annotation.getAttributeString("fetch");
        this.m_targetEntity = this.getMetadataClass(annotation == null ? "void" : annotation.getAttributeString("targetEntity"));
        CascadeMetadata cascadeMetadata = this.m_cascade = annotation == null ? null : new CascadeMetadata(annotation.getAttributeArray("cascade"), (MetadataAccessor)this);
        if (this.isAnnotationPresent(JoinFetch.class)) {
            this.m_joinFetch = this.getAnnotation(JoinFetch.class).getAttributeString("value");
        }
        if (this.isAnnotationPresent(BatchFetch.class)) {
            this.m_batchFetch = new BatchFetchMetadata(this.getAnnotation(BatchFetch.class), this);
        }
        if (this.isAnnotationPresent("javax.persistence.JoinColumns")) {
            MetadataAnnotation joinColumns = this.getAnnotation("javax.persistence.JoinColumns");
            Object[] objectArray = joinColumns.getAttributeArray("value");
            int n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Object joinColumn2 = objectArray[n];
                this.m_joinColumns.add(new JoinColumnMetadata((MetadataAnnotation)joinColumn2, this));
                ++n;
            }
            if (joinColumns.hasAttribute("foreignKey")) {
                this.setForeignKey(new ForeignKeyMetadata(joinColumns.getAttributeAnnotation("foreignKey"), this));
            }
        }
        if (this.isAnnotationPresent("javax.persistence.JoinColumn")) {
            joinColumn = new JoinColumnMetadata(this.getAnnotation("javax.persistence.JoinColumn"), this);
            this.m_joinColumns.add((JoinColumnMetadata)joinColumn);
            this.setForeignKey(((RelationalColumnMetadata)joinColumn).getForeignKey());
        }
        if (this.isAnnotationPresent("org.eclipse.persistence.nosql.annotations.JoinFields")) {
            Object[] objectArray = this.getAnnotation("org.eclipse.persistence.nosql.annotations.JoinFields").getAttributeArray("value");
            n = objectArray.length;
            int n3 = 0;
            while (n3 < n) {
                joinColumn = objectArray[n3];
                this.m_joinColumns.add(new JoinColumnMetadata((MetadataAnnotation)joinColumn, this));
                ++n3;
            }
        }
        if (this.isAnnotationPresent("org.eclipse.persistence.nosql.annotations.JoinField")) {
            this.m_joinColumns.add(new JoinColumnMetadata(this.getAnnotation("org.eclipse.persistence.nosql.annotations.JoinField"), this));
        }
        if (this.isAnnotationPresent("javax.persistence.JoinTable")) {
            this.m_joinTable = new JoinTableMetadata(this.getAnnotation("javax.persistence.JoinTable"), this);
        }
        this.m_privateOwned = this.isAnnotationPresent(PrivateOwned.class);
        this.m_cascadeOnDelete = this.isAnnotationPresent(CascadeOnDelete.class);
        this.m_nonCacheable = this.isAnnotationPresent(Noncacheable.class);
    }

    protected void addJoinTableRelationKeyFields(List<JoinColumnMetadata> joinColumns, RelationTableMechanism mechanism, String defaultFieldName, MetadataDescriptor descriptor, boolean isSource) {
        String FK_CTX;
        String PK_CTX;
        if (isSource) {
            PK_CTX = "metadata_default_source_pk_column";
            FK_CTX = "metadata_default_source_fk_column";
        } else {
            PK_CTX = "metadata_default_target_pk_column";
            FK_CTX = "metadata_default_target_fk_column";
        }
        for (JoinColumnMetadata joinColumn : joinColumns) {
            DatabaseField pkField = this.getReferencedField(joinColumn.getReferencedColumnName(), descriptor, PK_CTX);
            DatabaseField fkField = joinColumn.getForeignKeyField(pkField);
            String defaultFKFieldName = String.valueOf(defaultFieldName) + "_" + descriptor.getPrimaryKeyFieldName();
            this.setFieldName(fkField, defaultFKFieldName, FK_CTX);
            fkField.setTable(mechanism.getRelationTable());
            if (isSource) {
                mechanism.addSourceRelationKeyField(fkField, pkField);
                continue;
            }
            mechanism.addTargetRelationKeyField(fkField, pkField);
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof RelationshipAccessor) {
            RelationshipAccessor relationshipAccessor = (RelationshipAccessor)objectToCompare;
            if (!this.valuesMatch(this.m_orphanRemoval, relationshipAccessor.getOrphanRemoval())) {
                return false;
            }
            if (!this.valuesMatch(this.m_privateOwned, relationshipAccessor.getPrivateOwned())) {
                return false;
            }
            if (!this.valuesMatch(this.m_nonCacheable, relationshipAccessor.getNonCacheable())) {
                return false;
            }
            if (!this.valuesMatch(this.m_cascade, relationshipAccessor.getCascade())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mappedBy, relationshipAccessor.getMappedBy())) {
                return false;
            }
            if (!this.valuesMatch(this.m_fetch, relationshipAccessor.getFetch())) {
                return false;
            }
            if (!this.valuesMatch(this.m_joinFetch, relationshipAccessor.getJoinFetch())) {
                return false;
            }
            if (!this.valuesMatch(this.m_batchFetch, relationshipAccessor.getBatchFetch())) {
                return false;
            }
            if (!this.valuesMatch(this.m_joinTable, relationshipAccessor.getJoinTable())) {
                return false;
            }
            if (!this.valuesMatch(this.m_joinColumns, relationshipAccessor.getJoinColumns())) {
                return false;
            }
            if (!this.valuesMatch(this.m_foreignKey, relationshipAccessor.getForeignKey())) {
                return false;
            }
            return this.valuesMatch(this.m_targetEntityName, relationshipAccessor.getTargetEntityName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.m_orphanRemoval != null ? this.m_orphanRemoval.hashCode() : 0);
        result = 31 * result + (this.m_nonCacheable != null ? this.m_nonCacheable.hashCode() : 0);
        result = 31 * result + (this.m_privateOwned != null ? this.m_privateOwned.hashCode() : 0);
        result = 31 * result + (this.m_batchFetch != null ? this.m_batchFetch.hashCode() : 0);
        result = 31 * result + (this.m_cascade != null ? this.m_cascade.hashCode() : 0);
        result = 31 * result + (this.m_foreignKey != null ? this.m_foreignKey.hashCode() : 0);
        result = 31 * result + (this.m_joinTable != null ? this.m_joinTable.hashCode() : 0);
        result = 31 * result + (this.m_joinColumns != null ? this.m_joinColumns.hashCode() : 0);
        result = 31 * result + (this.m_fetch != null ? this.m_fetch.hashCode() : 0);
        result = 31 * result + (this.m_mappedBy != null ? this.m_mappedBy.hashCode() : 0);
        result = 31 * result + (this.m_joinFetch != null ? this.m_joinFetch.hashCode() : 0);
        result = 31 * result + (this.m_targetEntityName != null ? this.m_targetEntityName.hashCode() : 0);
        return result;
    }

    public BatchFetchMetadata getBatchFetch() {
        return this.m_batchFetch;
    }

    public Boolean getCascadeOnDelete() {
        return this.m_cascadeOnDelete;
    }

    public CascadeMetadata getCascade() {
        return this.m_cascade;
    }

    @Override
    public abstract String getDefaultFetchType();

    @Override
    protected DatabaseTable getDefaultTableForEntityMapKey() {
        if (this.getJoinTable() != null) {
            return this.getJoinTable().getDatabaseTable();
        }
        return super.getDefaultTableForEntityMapKey();
    }

    public String getFetch() {
        return this.m_fetch;
    }

    public ForeignKeyMetadata getForeignKey() {
        return this.m_foreignKey;
    }

    public List<JoinColumnMetadata> getJoinColumns() {
        return this.m_joinColumns;
    }

    public List<JoinFieldMetadata> getJoinFields() {
        return this.m_joinFields;
    }

    public String getJoinFetch() {
        return this.m_joinFetch;
    }

    public JoinTableMetadata getJoinTable() {
        return this.m_joinTable;
    }

    protected JoinTableMetadata getJoinTableMetadata() {
        if (this.getDescriptor().hasAssociationOverrideFor(this.getAttributeName())) {
            return this.getDescriptor().getAssociationOverrideFor(this.getAttributeName()).getJoinTable();
        }
        if (this.m_joinTable == null) {
            this.m_joinTable = new JoinTableMetadata(this.getClassAccessor());
        }
        return this.m_joinTable;
    }

    protected abstract String getLoggingContext();

    public String getMappedBy() {
        return this.m_mappedBy;
    }

    public Boolean getNonCacheable() {
        return this.m_nonCacheable;
    }

    public Boolean getOrphanRemoval() {
        return this.m_orphanRemoval;
    }

    protected DatabaseMapping getOwningMapping() {
        MetadataDescriptor ownerDescriptor = this.getReferenceDescriptor();
        MappingAccessor mappingAccessor = ownerDescriptor.getMappingAccessor(this.getMappedBy());
        if (mappingAccessor == null) {
            throw ValidationException.noMappedByAttributeFound(ownerDescriptor.getJavaClass(), this.getMappedBy(), this.getJavaClass(), this.getAttributeName());
        }
        if (mappingAccessor.isRelationship()) {
            RelationshipAccessor relationshipAccessor = (RelationshipAccessor)mappingAccessor;
            String mappedBy = relationshipAccessor.getMappedBy();
            if (mappedBy != null && mappedBy.equals(this.getAttributeName())) {
                throw ValidationException.circularMappedByReferences(this.getJavaClass(), this.getAttributeName(), this.getJavaClass(), this.getMappedBy());
            }
            if (!mappingAccessor.isProcessed()) {
                mappingAccessor.process();
            }
            if (this.getMapping() != null && this.getMapping().isForeignReferenceMapping()) {
                ((ForeignReferenceMapping)this.getMapping()).setMappedBy(mappedBy);
            }
        }
        return mappingAccessor.getMapping();
    }

    public Boolean getPrivateOwned() {
        return this.m_privateOwned;
    }

    @Override
    public MetadataDescriptor getReferenceDescriptor() {
        MetadataDescriptor referenceDescriptor;
        block4: {
            MetadataProcessor compositeProcessor;
            block3: {
                if ((!this.getDescriptor().isMappedSuperclass() || !this.getReferenceClassName().equals("java.lang.String")) && !this.getReferenceClass().isVoid()) break block3;
                MappingAccessor childMappingAccessor = this.getDescriptor().getMetamodelMappedSuperclassChildDescriptor().getMappingAccessor(this.getAttributeName());
                referenceDescriptor = childMappingAccessor.getReferenceDescriptor();
                if (!referenceDescriptor.isInheritanceSubclass()) break block4;
                referenceDescriptor = referenceDescriptor.getInheritanceRootDescriptor();
                break block4;
            }
            ClassAccessor accessor = this.getProject().getAccessor(this.getReferenceClassName());
            MetadataDescriptor metadataDescriptor = referenceDescriptor = accessor != null ? accessor.getDescriptor() : null;
            if (referenceDescriptor == null && (compositeProcessor = this.getProject().getCompositeProcessor()) != null) {
                for (MetadataProject pearProject : compositeProcessor.getPearProjects(this.getProject())) {
                    accessor = pearProject.getAccessor(this.getReferenceClassName());
                    if (accessor == null) continue;
                    referenceDescriptor = accessor.getDescriptor();
                    break;
                }
            }
        }
        if (referenceDescriptor == null || referenceDescriptor.isEmbeddable() || referenceDescriptor.isEmbeddableCollection()) {
            throw ValidationException.nonEntityTargetInRelationship(this.getJavaClass(), this.getReferenceClass(), this.getAnnotatedElement());
        }
        return referenceDescriptor;
    }

    public MetadataClass getTargetEntity() {
        return this.m_targetEntity;
    }

    public String getTargetEntityName() {
        return this.m_targetEntityName;
    }

    protected boolean hasJoinTable() {
        return this.m_joinTable != null;
    }

    public boolean hasMappedBy() {
        return this.getMappedBy() != null && !this.getMappedBy().equals("");
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        if (this.m_joinFields != null) {
            this.m_joinColumns.addAll(this.m_joinFields);
        }
        this.initXMLObjects(this.m_joinColumns, accessibleObject);
        this.initXMLObject(this.m_joinTable, accessibleObject);
        this.initXMLObject(this.m_cascade, accessibleObject);
        this.initXMLObject(this.m_foreignKey, accessibleObject);
        this.m_targetEntity = this.initXMLClassName(this.m_targetEntityName);
    }

    public boolean isCascadeOnDelete() {
        return this.m_cascadeOnDelete != null && this.m_cascadeOnDelete != false;
    }

    public boolean isLazy() {
        String fetchType = this.getFetch();
        if (fetchType == null) {
            fetchType = this.getDefaultFetchType();
        }
        return fetchType.equals("LAZY");
    }

    public boolean isNonCacheable() {
        return this.m_nonCacheable != null && this.m_nonCacheable != false;
    }

    protected boolean isOrphanRemoval() {
        return this.m_orphanRemoval != null && this.m_orphanRemoval != false;
    }

    public boolean isPrivateOwned() {
        return this.m_privateOwned != null && this.m_privateOwned != false;
    }

    public boolean isValueHolderInterface() {
        return this.getTargetEntity().getName().equals(ValueHolderInterface.class.getName()) || this.getTargetEntity().getName().equals(Void.TYPE.getName()) && this.getReferenceClass().getName().equals(ValueHolderInterface.class.getName());
    }

    @Override
    public void process() {
        if (!this.isProcessed()) {
            if (this.isAnnotationPresent("javax.persistence.Column")) {
                throw ValidationException.invalidColumnAnnotationOnRelationship(this.getJavaClass(), this.getAttributeName());
            }
            if (this.isAnnotationPresent(Convert.class)) {
                throw ValidationException.invalidMappingForConverter(this.getJavaClass(), this.getAttributeName());
            }
        }
    }

    protected void processBatchFetch(ForeignReferenceMapping mapping) {
        if (this.m_batchFetch != null) {
            this.m_batchFetch.process(mapping);
        }
    }

    protected void processCascadeTypes(ForeignReferenceMapping mapping) {
        if (this.m_cascade != null) {
            this.m_cascade.process(mapping);
        }
        if (this.getDescriptor().isCascadePersist() && !mapping.isCascadePersist()) {
            mapping.setCascadePersist(true);
        }
    }

    protected void processJoinTable(ForeignReferenceMapping mapping, RelationTableMechanism mechanism, JoinTableMetadata joinTable) {
        String defaultName = String.valueOf(this.getOwningDescriptor().getPrimaryTableName()) + "_" + this.getReferenceDescriptor().getPrimaryTableName();
        this.processTable(joinTable, defaultName);
        mechanism.setRelationTable(joinTable.getDatabaseTable());
        String defaultSourceFieldName = this.getReferenceDescriptor().hasBiDirectionalManyToManyAccessorFor(this.getJavaClassName(), this.getAttributeName()) ? this.getReferenceDescriptor().getBiDirectionalManyToManyAccessor(this.getJavaClassName(), this.getAttributeName()).getAttributeName() : this.getOwningDescriptor().getAlias();
        this.addJoinTableRelationKeyFields(this.getJoinColumnsAndValidate(joinTable.getJoinColumns(), this.getOwningDescriptor()), mechanism, defaultSourceFieldName, this.getOwningDescriptor(), true);
        String defaultTargetFieldName = this.getAttributeName();
        this.addJoinTableRelationKeyFields(this.getJoinColumnsAndValidate(joinTable.getInverseJoinColumns(), this.getReferenceDescriptor()), mechanism, defaultTargetFieldName, this.getReferenceDescriptor(), false);
        mapping.setShouldExtendPessimisticLockScope(true);
    }

    protected void processMappedByRelationTable(RelationTableMechanism ownerMechanism, RelationTableMechanism mechanism) {
        mechanism.setRelationTable(ownerMechanism.getRelationTable());
        if (this.getDescriptor().usesTablePerClassInheritanceStrategy()) {
            Vector<DatabaseField> targetKeyFields = new Vector<DatabaseField>();
            for (DatabaseField targetKeyField : ownerMechanism.getTargetKeyFields()) {
                DatabaseField newTargetKeyField = targetKeyField.clone();
                newTargetKeyField.setTable(this.getDescriptor().getPrimaryTable());
                targetKeyFields.add(newTargetKeyField);
            }
            mechanism.setSourceKeyFields(targetKeyFields);
        } else {
            mechanism.setSourceKeyFields(ownerMechanism.getTargetKeyFields());
        }
        mechanism.setSourceRelationKeyFields(ownerMechanism.getTargetRelationKeyFields());
        mechanism.setTargetKeyFields(ownerMechanism.getSourceKeyFields());
        mechanism.setTargetRelationKeyFields(ownerMechanism.getSourceRelationKeyFields());
    }

    protected void processOrphanRemoval(ForeignReferenceMapping mapping) {
        if (this.isOrphanRemoval()) {
            mapping.setIsPrivateOwned(true);
            mapping.setCascadeRemove(true);
        } else {
            mapping.setIsPrivateOwned(this.isPrivateOwned());
        }
    }

    protected void processRelationshipMapping(ForeignReferenceMapping mapping) {
        this.setMapping(mapping);
        mapping.setIsLazy(this.isLazy());
        mapping.setAttributeName(this.getAttributeName());
        mapping.setReferenceClassName(this.getReferenceClassName());
        mapping.setIsCascadeOnDeleteSetOnDatabase(this.isCascadeOnDelete());
        this.processJoinFetch(this.getJoinFetch(), mapping);
        this.processBatchFetch(mapping);
        this.processOrphanRemoval(mapping);
        this.setAccessorMethods(mapping);
        this.processCascadeTypes(mapping);
        this.processPartitioning();
        mapping.setIsCacheable(!this.isNonCacheable());
    }

    @Override
    protected void setAccessorMethods(DatabaseMapping mapping) {
        super.setAccessorMethods(mapping);
        ((ForeignReferenceMapping)mapping).setRequiresTransientWeavedFields(this.usesPropertyAccess() && !this.getClassAccessor().usesPropertyAccess());
    }

    public void setBatchFetch(BatchFetchMetadata batchFetch) {
        this.m_batchFetch = batchFetch;
    }

    public void setCascade(CascadeMetadata cascade) {
        this.m_cascade = cascade;
    }

    public void setCascadeOnDelete(Boolean cascadeOnDelete) {
        this.m_cascadeOnDelete = cascadeOnDelete;
    }

    public void setFetch(String fetch) {
        this.m_fetch = fetch;
    }

    public void setForeignKey(ForeignKeyMetadata foreignKey) {
        this.m_foreignKey = foreignKey;
    }

    public void setJoinColumns(List<JoinColumnMetadata> joinColumns) {
        this.m_joinColumns = joinColumns;
    }

    public void setJoinFields(List<JoinFieldMetadata> joinFields) {
        this.m_joinFields = joinFields;
    }

    public void setJoinFetch(String joinFetch) {
        this.m_joinFetch = joinFetch;
    }

    public void setJoinTable(JoinTableMetadata joinTable) {
        this.m_joinTable = joinTable;
    }

    public void setMappedBy(String mappedBy) {
        this.m_mappedBy = mappedBy;
    }

    public void setNonCacheable(Boolean noncacheable) {
        this.m_nonCacheable = noncacheable;
    }

    public void setOrphanRemoval(Boolean orphanRemoval) {
        this.m_orphanRemoval = orphanRemoval;
    }

    public void setPrivateOwned(Boolean privateOwned) {
        this.m_privateOwned = privateOwned;
    }

    public void setTargetEntity(MetadataClass targetEntity) {
        this.m_targetEntity = targetEntity;
    }

    public void setTargetEntityName(String targetEntityName) {
        this.m_targetEntityName = targetEntityName;
    }

    @Override
    protected boolean usesIndirection() {
        if (this.getProject().isWeavingEagerEnabled()) {
            return true;
        }
        return this.isLazy();
    }
}

